"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.handleUpdateCommandState = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const handleUpdateCommandState = (state, {
  type,
  payload: {
    id,
    value
  }
}) => {
  let foundIt = false;
  const updatedCommandHistory = state.commandHistory.map(item => {
    if (foundIt || item.id !== id) {
      return item;
    }
    foundIt = true;
    const updatedCommandState = {
      ...item,
      state: {
        ...item.state
      }
    };
    switch (type) {
      case 'updateCommandStoreState':
        updatedCommandState.state.store = value(updatedCommandState.state.store);
        break;
      case 'updateCommandStatusState':
        // If the status was not changed, then there is nothing to be done here, so
        // instead of triggering a state change (and UI re-render), just return the
        // original item;
        if (updatedCommandState.state.status === value) {
          foundIt = false;
          return item;
        }
        updatedCommandState.state.status = value;
        break;
    }
    return updatedCommandState;
  });
  if (foundIt) {
    return {
      ...state,
      commandHistory: updatedCommandHistory
    };
  }
  return state;
};
exports.handleUpdateCommandState = handleUpdateCommandState;