"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PreviewPanelFooter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _expandableFlyout = require("@kbn/expandable-flyout");
var _test_ids = require("./test_ids");
var _ = require(".");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/network_details/footer.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Footer at the bottom of preview panel with a link to open network details flyout
 */
const PreviewPanelFooter = ({
  ip,
  flowTarget,
  scopeId
}) => {
  const {
    openFlyout
  } = (0, _expandableFlyout.useExpandableFlyoutApi)();
  const openNetworkFlyout = (0, _react.useCallback)(() => {
    openFlyout({
      right: {
        id: _.NetworkPanelKey,
        params: {
          ip,
          flowTarget,
          scopeId
        }
      }
    });
  }, [openFlyout, flowTarget, ip, scopeId]);
  const fullDetailsLink = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: openNetworkFlyout,
    target: "_blank",
    "data-test-subj": _test_ids.PREVIEW_FOOTER_LINK_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('xpack.securitySolution.flyout.network.preview.openFlyoutLabel', {
    defaultMessage: 'Show full network details'
  }))), [openNetworkFlyout]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    "data-test-subj": _test_ids.PREVIEW_FOOTER_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "transparent",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 11
    }
  }, fullDetailsLink))));
};
exports.PreviewPanelFooter = PreviewPanelFooter;