"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TakeAction = exports.TAKE_ACTION_BUTTON_TEST_ID = exports.INVESTIGATE_IN_TIMELINE_TEST_ID = exports.ADD_TO_NEW_CASE_TEST_ID = exports.ADD_TO_EXISTING_CASE_TEST_ID = exports.ADD_TO_BLOCK_LIST_TEST_ID = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _flyout = require("../../../threat_intelligence/modules/block_list/containers/flyout");
var _context = require("../context");
var _can_add_to_block_list = require("../../../threat_intelligence/modules/block_list/utils/can_add_to_block_list");
var _add_to_block_list = require("../../../threat_intelligence/modules/block_list/components/add_to_block_list");
var _add_to_new_case = require("../../../threat_intelligence/modules/cases/components/add_to_new_case");
var _add_to_existing_case = require("../../../threat_intelligence/modules/cases/components/add_to_existing_case");
var _investigate_in_timeline = require("../../../threat_intelligence/modules/timeline/components/investigate_in_timeline");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/ioc_details/components/take_action.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TAKE_ACTION_BUTTON_TEST_ID = exports.TAKE_ACTION_BUTTON_TEST_ID = 'tiIndicatorFlyoutTakeActionButton';
const INVESTIGATE_IN_TIMELINE_TEST_ID = exports.INVESTIGATE_IN_TIMELINE_TEST_ID = 'tiIndicatorFlyoutInvestigateInTimelineContextMenu';
const ADD_TO_EXISTING_CASE_TEST_ID = exports.ADD_TO_EXISTING_CASE_TEST_ID = 'tiIndicatorFlyoutAddToExistingCaseContextMenu';
const ADD_TO_NEW_CASE_TEST_ID = exports.ADD_TO_NEW_CASE_TEST_ID = 'tiIndicatorFlyoutAddToNewCaseContextMenu';
const ADD_TO_BLOCK_LIST_TEST_ID = exports.ADD_TO_BLOCK_LIST_TEST_ID = 'tiIndicatorFlyoutAddToBlockListContextMenu';

/**
 * Component rendered at the bottom of the indicators flyout
 */
const TakeAction = exports.TakeAction = /*#__PURE__*/(0, _react.memo)(() => {
  const {
    indicator
  } = (0, _context.useIOCDetailsContext)();
  const [blockListIndicatorValue, setBlockListIndicatorValue] = (0, _react.useState)('');
  const [isPopoverOpen, setPopover] = (0, _react.useState)(false);
  const smallContextMenuPopoverId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'smallContextMenuPopover'
  });
  const closePopover = (0, _react.useCallback)(() => {
    setPopover(false);
  }, []);
  const items = (0, _react.useMemo)(() => [/*#__PURE__*/_react.default.createElement(_investigate_in_timeline.InvestigateInTimelineContextMenu, {
    key: 'investigateInTime',
    data: indicator,
    onClick: closePopover,
    "data-test-subj": INVESTIGATE_IN_TIMELINE_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_add_to_existing_case.AddToExistingCase, {
    key: 'attachmentsExistingCase',
    indicator: indicator,
    onClick: closePopover,
    "data-test-subj": ADD_TO_EXISTING_CASE_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_add_to_new_case.AddToNewCase, {
    key: 'attachmentsNewCase',
    indicator: indicator,
    onClick: closePopover,
    "data-test-subj": ADD_TO_NEW_CASE_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_add_to_block_list.AddToBlockListContextMenu, {
    key: 'addToBlocklist',
    data: (0, _can_add_to_block_list.canAddToBlockList)(indicator),
    onClick: closePopover,
    "data-test-subj": ADD_TO_BLOCK_LIST_TEST_ID,
    setBlockListIndicatorValue: setBlockListIndicatorValue,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 7
    }
  })], [closePopover, indicator]);
  const button = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconType: "arrowDown",
    iconSide: "right",
    onClick: () => setPopover(!isPopoverOpen),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.threatIntelligence.indicators.flyout.take-action.button",
    defaultMessage: "Take action",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 9
    }
  })), [isPopoverOpen]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: smallContextMenuPopoverId,
    button: button,
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none",
    anchorPosition: "downLeft",
    "data-test-subj": TAKE_ACTION_BUTTON_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    size: "s",
    items: items,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 9
    }
  })), blockListIndicatorValue && /*#__PURE__*/_react.default.createElement(_flyout.BlockListFlyout, {
    indicatorFileHash: blockListIndicatorValue,
    setBlockListIndicatorValue: setBlockListIndicatorValue,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 9
    }
  }));
});
TakeAction.displayName = 'TakeAction';