"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HostPanelContent = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _use_experimental_features = require("../../../common/hooks/use_experimental_features");
var _entity_highlights = require("../../../entity_analytics/components/entity_details_flyout/components/entity_highlights");
var _flyout_body = require("../../shared/components/flyout_body");
var _entity_insight = require("../../../cloud_security_posture/components/entity_insight");
var _asset_criticality_selector = require("../../../entity_analytics/components/asset_criticality/asset_criticality_selector");
var _risk_summary = require("../../../entity_analytics/components/risk_summary_flyout/risk_summary");
var _types = require("../../../../common/entity_analytics/types");
var _observed_entity = require("../shared/components/observed_entity");
var _ = require(".");
var _use_observed_host_fields = require("./hooks/use_observed_host_fields");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/entity_details/host_right/content.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const HostPanelContent = ({
  hostName,
  observedHost,
  riskScoreState,
  recalculatingScore,
  contextID,
  scopeId,
  openDetailsPanel,
  onAssetCriticalityChange,
  isPreviewMode
}) => {
  var _riskScoreState$data;
  const observedFields = (0, _use_observed_host_fields.useObservedHostFields)(observedHost);
  const isEntityDetailsHighlightsAIEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('entityDetailsHighlightsEnabled');
  return /*#__PURE__*/_react.default.createElement(_flyout_body.FlyoutBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 5
    }
  }, isEntityDetailsHighlightsAIEnabled && /*#__PURE__*/_react.default.createElement(_entity_highlights.EntityHighlightsAccordion, {
    entityIdentifier: hostName,
    entityType: _types.EntityType.host,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 9
    }
  }), riskScoreState.hasEngineBeenInstalled && ((_riskScoreState$data = riskScoreState.data) === null || _riskScoreState$data === void 0 ? void 0 : _riskScoreState$data.length) !== 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_risk_summary.FlyoutRiskSummary, {
    entityType: _types.EntityType.host,
    riskScoreData: riskScoreState,
    recalculatingScore: recalculatingScore,
    queryId: _.HOST_PANEL_RISK_SCORE_QUERY_ID,
    openDetailsPanel: openDetailsPanel,
    isPreviewMode: isPreviewMode,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_asset_criticality_selector.AssetCriticalityAccordion, {
    entity: {
      name: hostName,
      type: _types.EntityType.host
    },
    onChange: onAssetCriticalityChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_entity_insight.EntityInsight, {
    value: hostName,
    field: _types.EntityIdentifierFields.hostName,
    isPreviewMode: isPreviewMode,
    openDetailsPanel: openDetailsPanel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_observed_entity.ObservedEntity, {
    observedData: observedHost,
    contextID: contextID,
    scopeId: scopeId,
    observedFields: observedFields,
    queryId: _.HOST_PANEL_OBSERVED_HOST_QUERY_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 7
    }
  }));
};
exports.HostPanelContent = HostPanelContent;