"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAssetInventoryAssistant = void 0;
var _react = require("react");
var _elasticAssistant = require("@kbn/elastic-assistant");
var _use_assistant_availability = require("../../../../assistant/use_assistant_availability");
var _prompt_contexts = require("../../../../assistant/content/prompt_contexts");
var _translations = require("../../shared/translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Fallback implementation when assistant is not available
const useAssistantNoop = () => ({
  promptContextId: undefined,
  showAssistantOverlay: show => {}
});
/**
 * Hook to return the assistant button visibility and prompt context id for Asset Inventory entities
 */
const useAssetInventoryAssistant = ({
  entityId,
  entityFields,
  isPreviewMode,
  assetCriticalityLevel
}) => {
  const {
    hasAssistantPrivilege,
    isAssistantEnabled,
    isAssistantVisible
  } = (0, _use_assistant_availability.useAssistantAvailability)();
  const {
    basePromptContexts
  } = (0, _elasticAssistant.useAssistantContext)();
  const suggestedUserPrompt = (0, _react.useMemo)(() => {
    var _basePromptContexts$f;
    return (_basePromptContexts$f = basePromptContexts.find(({
      category
    }) => category === _prompt_contexts.PROMPT_CONTEXT_ASSET_CATEGORY)) === null || _basePromptContexts$f === void 0 ? void 0 : _basePromptContexts$f.suggestedUserPrompt;
  }, [basePromptContexts]);
  const useAssistantHook = hasAssistantPrivilege ? _elasticAssistant.useAssistantOverlay : useAssistantNoop;
  const getPromptContext = (0, _react.useCallback)(async () => {
    const fields = entityFields || {};

    // If we have fresh criticality data from the asset criticality indexes, add/update it in the context
    if (assetCriticalityLevel) {
      return {
        ...fields,
        'asset.criticality': [assetCriticalityLevel]
      };
    }
    return fields;
  }, [entityFields, assetCriticalityLevel]);
  const uniqueName = (0, _react.useMemo)(() => {
    const entityName = entityId || _translations.ENTITY_SUMMARY_CONVERSATION_ID;
    return `${entityName}`;
  }, [entityId]);
  const {
    promptContextId,
    showAssistantOverlay
  } = useAssistantHook('entity', uniqueName, (0, _translations.ENTITY_SUMMARY_CONTEXT_DESCRIPTION)(_translations.SUMMARY_VIEW), getPromptContext, null, suggestedUserPrompt, _translations.ENTITY_SUMMARY_VIEW_CONTEXT_TOOLTIP, isAssistantEnabled);
  return {
    showAssistant: isAssistantEnabled && hasAssistantPrivilege && promptContextId !== null && isAssistantVisible && !isPreviewMode,
    showAssistantOverlay,
    promptContextId: promptContextId || ''
  };
};
exports.useAssetInventoryAssistant = useAssetInventoryAssistant;