"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEaseDetailsContext = exports.EaseDetailsProvider = exports.EaseDetailsContext = void 0;
var _react = _interopRequireWildcard(require("react"));
var _useLocalStorage = _interopRequireDefault(require("react-use/lib/useLocalStorage"));
var _use_create_data_view = require("../../detections/hooks/alert_summary/use_create_data_view");
var _use_document_details = require("./hooks/use_document_details");
var _use_rule_with_fallback = require("../../detection_engine/rule_management/logic/use_rule_with_fallback");
var _use_space_id = require("../../common/hooks/use_space_id");
var _flyout_loading = require("../shared/components/flyout_loading");
var _flyout_error = require("../shared/components/flyout_error");
var _use_basic_data_from_details_data = require("../document_details/shared/hooks/use_basic_data_from_details_data");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/ease/context.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * A context provider for EASE alert summary flyout
 */
const EaseDetailsContext = exports.EaseDetailsContext = /*#__PURE__*/(0, _react.createContext)(undefined);
const EaseDetailsProvider = exports.EaseDetailsProvider = /*#__PURE__*/(0, _react.memo)(({
  id,
  children
}) => {
  const {
    dataView
  } = (0, _use_create_data_view.useCreateEaseAlertsDataView)();
  const spaceId = (0, _use_space_id.useSpaceId)();
  const {
    dataAsNestedObject,
    dataFormattedForFieldBrowser,
    getFieldsData,
    loading
  } = (0, _use_document_details.useDocumentDetails)({
    dataView,
    documentId: id
  });
  const {
    ruleId
  } = (0, _use_basic_data_from_details_data.useBasicDataFromDetailsData)(dataFormattedForFieldBrowser);
  const {
    rule: maybeRule
  } = (0, _use_rule_with_fallback.useRuleWithFallback)(ruleId);
  const [showAnonymizedValues = spaceId ? false : undefined, setShowAnonymizedValues] = (0, _useLocalStorage.default)(`securitySolution.aiAlertFlyout.showAnonymization.${spaceId}`);
  const contextValue = (0, _react.useMemo)(() => {
    var _maybeRule$investigat, _maybeRule$investigat2;
    return dataFormattedForFieldBrowser && dataAsNestedObject && id && dataView ? {
      dataFormattedForFieldBrowser,
      dataAsNestedObject,
      eventId: id,
      getFieldsData,
      investigationFields: (_maybeRule$investigat = maybeRule === null || maybeRule === void 0 ? void 0 : (_maybeRule$investigat2 = maybeRule.investigation_fields) === null || _maybeRule$investigat2 === void 0 ? void 0 : _maybeRule$investigat2.field_names) !== null && _maybeRule$investigat !== void 0 ? _maybeRule$investigat : [],
      setShowAnonymizedValues,
      showAnonymizedValues
    } : undefined;
  }, [dataAsNestedObject, dataFormattedForFieldBrowser, dataView, getFieldsData, id, maybeRule, setShowAnonymizedValues, showAnonymizedValues]);
  if (loading) {
    return /*#__PURE__*/_react.default.createElement(_flyout_loading.FlyoutLoading, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 107,
        columnNumber: 12
      }
    });
  }
  if (!contextValue) {
    return /*#__PURE__*/_react.default.createElement(_flyout_error.FlyoutError, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 111,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(EaseDetailsContext.Provider, {
    value: contextValue,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 10
    }
  }, children);
});
EaseDetailsProvider.displayName = 'EaseDetailsProvider';
const useEaseDetailsContext = () => {
  const contextValue = (0, _react.useContext)(EaseDetailsContext);
  if (!contextValue) {
    throw new Error('EaseDetailsContext can only be used within EaseDetailsContext provider');
  }
  return contextValue;
};
exports.useEaseDetailsContext = useEaseDetailsContext;