"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnonymizationSwitch = exports.ALERT_SUMMARY_ANONYMIZE_TOGGLE_TEST_ID = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _context = require("../context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/ease/components/anonymization_switch.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ALERT_SUMMARY_ANONYMIZE_TOGGLE_TEST_ID = exports.ALERT_SUMMARY_ANONYMIZE_TOGGLE_TEST_ID = 'ease-alert-flyout-alert-summary-anonymize-toggle';

/**
 * Conditionally wrap a component
 */
const ConditionalWrap = ({
  condition,
  wrap,
  children
}) => condition ? wrap(children) : children;
/**
 * Renders a toggle switch used in EASE alert summary flyout in the AI summary section.
 * This enables/disables anonymized values.
 */
const AnonymizationSwitch = exports.AnonymizationSwitch = /*#__PURE__*/(0, _react.memo)(({
  hasAlertSummary
}) => {
  const {
    showAnonymizedValues,
    setShowAnonymizedValues
  } = (0, _context.useEaseDetailsContext)();
  const onChangeShowAnonymizedValues = (0, _react.useCallback)(e => {
    setShowAnonymizedValues(e.target.checked);
  }, [setShowAnonymizedValues]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, showAnonymizedValues !== undefined && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(ConditionalWrap, {
    condition: !hasAlertSummary,
    wrap: children => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      key: 'disabled-anonymize-values-tooltip',
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.flyout.settings.anonymizeValues.disabled.tooltip",
        defaultMessage: "The alert summary has not generated, and does not contain anonymized fields.",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 64,
          columnNumber: 21
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 60,
        columnNumber: 17
      }
    }, children),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    "data-test-subj": ALERT_SUMMARY_ANONYMIZE_TOGGLE_TEST_ID,
    checked: showAnonymizedValues !== null && showAnonymizedValues !== void 0 ? showAnonymizedValues : false,
    compressed: true,
    disabled: !hasAlertSummary,
    label: _i18n.i18n.translate('xpack.securitySolution.flyout.settings.anonymizeValues', {
      defaultMessage: 'Show anonymized values'
    }),
    onChange: onChangeShowAnonymizedValues,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    position: "top",
    key: 'anonymize-values-tooltip',
    content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.settings.anonymizeValues.tooltip",
      defaultMessage: "Toggle to reveal or obfuscate field values in your alert summary. The data sent to the LLM is still anonymized based on settings in Configurations > AI Settings > Anonymization.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 91,
        columnNumber: 17
      }
    }),
    type: "info",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 13
    }
  }))));
});
AnonymizationSwitch.displayName = 'AnonymizationSwitch';