"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEventDetails = exports.getAlertIndexAlias = void 0;
var _securitySolutionNavigation = require("@kbn/security-solution-navigation");
var _constants = require("../../../../data_view_manager/constants");
var _use_experimental_features = require("../../../../common/hooks/use_experimental_features");
var _constants2 = require("../../../../../common/constants");
var _use_space_id = require("../../../../common/hooks/use_space_id");
var _use_route_spy = require("../../../../common/utils/route/use_route_spy");
var _containers = require("../../../../sourcerer/containers");
var _details = require("../../../../timelines/containers/details");
var _use_get_fields_data = require("./use_get_fields_data");
var _use_data_view = require("../../../../data_view_manager/hooks/use_data_view");
var _use_browser_fields = require("../../../../data_view_manager/hooks/use_browser_fields");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * The referenced alert _index in the flyout uses the `.internal.` such as `.internal.alerts-security.alerts-spaceId` in the alert page flyout and .internal.preview.alerts-security.alerts-spaceId` in the rule creation preview flyout,
 * but we always want to use their respective aliase indices rather than accessing their backing .internal. indices.
 */
const getAlertIndexAlias = (index, spaceId = 'default') => {
  if (index.startsWith(`.internal${_constants2.DEFAULT_ALERTS_INDEX}`)) {
    return `${_constants2.DEFAULT_ALERTS_INDEX}-${spaceId}`;
  } else if (index.startsWith(`.internal${_constants2.DEFAULT_PREVIEW_INDEX}`)) {
    return `${_constants2.DEFAULT_PREVIEW_INDEX}-${spaceId}`;
  }
};
exports.getAlertIndexAlias = getAlertIndexAlias;
/**
 * Hook to retrieve event details for alert details flyout contexts
 */
const useEventDetails = ({
  eventId,
  indexName
}) => {
  var _getAlertIndexAlias;
  const currentSpaceId = (0, _use_space_id.useSpaceId)();
  // TODO Replace getAlertIndexAlias way to retrieving the eventIndex with the GET /_alias
  //  https://github.com/elastic/kibana/issues/113063
  const eventIndex = indexName ? (_getAlertIndexAlias = getAlertIndexAlias(indexName, currentSpaceId)) !== null && _getAlertIndexAlias !== void 0 ? _getAlertIndexAlias : indexName : '';
  const [{
    pageName
  }] = (0, _use_route_spy.useRouteSpy)();
  const sourcererScope = pageName === _securitySolutionNavigation.SecurityPageName.detections ? _constants.PageScope.alerts : _constants.PageScope.default;
  const sourcererDataView = (0, _containers.useSourcererDataView)(sourcererScope);
  const oldRuntimeMappings = sourcererDataView.sourcererDataView.runtimeFieldMap;
  const oldBrowserFields = sourcererDataView.browserFields;
  const newDataViewPickerEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newDataViewPickerEnabled');
  const {
    dataView
  } = (0, _use_data_view.useDataView)(sourcererScope);
  const experimentalBrowserFields = (0, _use_browser_fields.useBrowserFields)(sourcererScope);
  const runtimeMappings = newDataViewPickerEnabled ? dataView === null || dataView === void 0 ? void 0 : dataView.getRuntimeMappings() : oldRuntimeMappings;
  const browserFields = newDataViewPickerEnabled ? experimentalBrowserFields : oldBrowserFields;
  const [loading, dataFormattedForFieldBrowser, searchHit, dataAsNestedObject, refetchFlyoutData] = (0, _details.useTimelineEventsDetails)({
    indexName: eventIndex,
    eventId: eventId !== null && eventId !== void 0 ? eventId : '',
    runtimeMappings,
    skip: !eventId
  });
  const {
    getFieldsData
  } = (0, _use_get_fields_data.useGetFieldsData)({
    fieldsData: searchHit === null || searchHit === void 0 ? void 0 : searchHit.fields
  });
  return {
    browserFields,
    dataAsNestedObject,
    dataFormattedForFieldBrowser,
    getFieldsData,
    loading,
    refetchFlyoutData,
    searchHit
  };
};
exports.useEventDetails = useEventDetails;