"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RelatedCases = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _correlations_details = require("../../left/components/correlations_details");
var _test_ids = require("./test_ids");
var _insights_summary_row = require("./insights_summary_row");
var _use_fetch_related_cases = require("../../shared/hooks/use_fetch_related_cases");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/document_details/right/components/related_cases.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Show related cases in summary row
 */
const RelatedCases = ({
  eventId
}) => {
  const {
    loading,
    error,
    dataCount
  } = (0, _use_fetch_related_cases.useFetchRelatedCases)({
    eventId
  });
  const text = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.right.insights.correlations.relatedCasesLabel",
    defaultMessage: "Related {count, plural, one {case} other {cases}}",
    values: {
      count: dataCount
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 7
    }
  }), [dataCount]);
  return /*#__PURE__*/_react.default.createElement(_insights_summary_row.InsightsSummaryRow, {
    loading: loading,
    error: error,
    text: text,
    value: dataCount,
    expandedSubTab: _correlations_details.CORRELATIONS_TAB_ID,
    "data-test-subj": _test_ids.CORRELATIONS_RELATED_CASES_TEST_ID,
    key: `correlation-row-${text}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 5
    }
  });
};
exports.RelatedCases = RelatedCases;
RelatedCases.displayName = 'RelatedCases';