"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTabs = exports.tabsDisplayed = void 0;
var _react = require("react");
var tabs = _interopRequireWildcard(require("../tabs"));
var _kibana = require("../../../common/lib/kibana");
var _local_storage = require("../constants/local_storage");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const tabsDisplayed = exports.tabsDisplayed = [tabs.overviewTab, tabs.tableTab, tabs.jsonTab];
/**
 * Hook to get the tabs to display in the attack details panel and the selected tab.
 */
const useTabs = ({
  path
}) => {
  const {
    storage
  } = (0, _kibana.useKibana)().services;
  const selectedTabId = (0, _react.useMemo)(() => {
    // we use the value passed from the url and use it if it exists in the list of tabs to display
    if (path) {
      const selectedTab = tabsDisplayed.map(tab => tab.id).find(tabId => tabId === path.tab);
      if (selectedTab) {
        return selectedTab;
      }
    }

    // we check the tab saved in local storage and use it if it exists in the list of tabs to display
    const tabSavedInlocalStorage = storage.get(_local_storage.FLYOUT_STORAGE_KEYS.RIGHT_PANEL_SELECTED_TABS);
    if (tabSavedInlocalStorage && tabsDisplayed.map(tab => tab.id).includes(tabSavedInlocalStorage)) {
      return tabSavedInlocalStorage;
    }
    const defaultTab = tabsDisplayed[0].id;
    return defaultTab;
  }, [path, storage]);
  return {
    tabsDisplayed,
    selectedTabId
  };
};
exports.useTabs = useTabs;