"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PrivilegedUserMonitoringManageDataSources = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _csv_upload_manage_data_source = require("./csv_upload_manage_data_source");
var _header_page = require("../../../common/components/header_page");
var _use_space_id = require("../../../common/hooks/use_space_id");
var _index_import_manage_data_source = require("./index_import_manage_data_source");
var _integrations_manage_data_source = require("./integrations_manage_data_source");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/entity_analytics/components/privileged_user_monitoring_manage_data_sources/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const PrivilegedUserMonitoringManageDataSources = ({
  onBackToDashboardClicked
}) => {
  var _application$capabili, _application$capabili2, _application$capabili3;
  const spaceId = (0, _use_space_id.useSpaceId)();
  const [addDataSourceResult, setAddDataSourceResult] = (0, _react.useState)();
  const {
    application
  } = (0, _public.useKibana)().services;
  const fleetRead = (_application$capabili = application === null || application === void 0 ? void 0 : (_application$capabili2 = application.capabilities) === null || _application$capabili2 === void 0 ? void 0 : (_application$capabili3 = _application$capabili2.fleetv2) === null || _application$capabili3 === void 0 ? void 0 : _application$capabili3.read) !== null && _application$capabili !== void 0 ? _application$capabili : false;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    flush: "left",
    iconType: "arrowLeft",
    iconSide: "left",
    onClick: onBackToDashboardClicked,
    "aria-label": _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.manageDataSources.backAriaLabel', {
      defaultMessage: 'Back to privileged user monitoring'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.manageDataSources.back",
    defaultMessage: "Back to privileged user monitoring",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_header_page.HeaderPage, {
    border: true,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.manageDataSources.title",
      defaultMessage: "Manage data sources",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 57,
        columnNumber: 11
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 7
    }
  }), (addDataSourceResult === null || addDataSourceResult === void 0 ? void 0 : addDataSourceResult.successful) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    title: addDataSourceResult.userCount > 0 ? _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.manageDataSources.successMessage', {
      defaultMessage: 'New data source of privileged users successfully set up: {userCount} users added',
      values: {
        userCount: addDataSourceResult.userCount
      }
    }) : _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.manageDataSources.successMessageWithoutUserCount', {
      defaultMessage: 'New data source of privileged users successfully set up'
    }),
    color: "success",
    iconType: "check",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 11
    }
  })), !fleetRead && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.manageDataSources.integrations.noAccessMessage",
      defaultMessage: "Insufficient privileges to view or manage integrations data source. Please contact your administrator.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 94,
        columnNumber: 13
      }
    }),
    color: "warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 9
    }
  }), fleetRead && /*#__PURE__*/_react.default.createElement(_integrations_manage_data_source.IntegrationsManageDataSource, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 21
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_index_import_manage_data_source.IndexImportManageDataSource, {
    setAddDataSourceResult: setAddDataSourceResult,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 7
    }
  }), spaceId && /*#__PURE__*/_react.default.createElement(_csv_upload_manage_data_source.CsvUploadManageDataSource, {
    setAddDataSourceResult: setAddDataSourceResult,
    namespace: spaceId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 9
    }
  }));
};
exports.PrivilegedUserMonitoringManageDataSources = PrivilegedUserMonitoringManageDataSources;