"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getResponseActionsFromNote = exports.getOsqueryQueriesFromNote = void 0;
var _unified = _interopRequireDefault(require("unified"));
var _remarkParseNoTrim = _interopRequireDefault(require("remark-parse-no-trim"));
var _lodash = require("lodash");
var _rule_response_actions = require("../../../common/api/detection_engine/model/rule_response_actions");
var _parser = require("../../common/components/markdown_editor/plugins/osquery/parser");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getOsqueryQueriesFromNote = note => {
  const parsedAlertInvestigationGuide = (0, _unified.default)().use([[_remarkParseNoTrim.default, {}], _parser.OsqueryParser]).parse(note);
  return (0, _lodash.filter)(parsedAlertInvestigationGuide === null || parsedAlertInvestigationGuide === void 0 ? void 0 : parsedAlertInvestigationGuide.children, ['type', 'osquery']);
};
exports.getOsqueryQueriesFromNote = getOsqueryQueriesFromNote;
const getResponseActionsFromNote = (osqueryQueries, defaultResponseActions = []) => {
  return (0, _lodash.reduce)(osqueryQueries, (acc, {
    configuration
  }) => {
    const responseActionPath = 'responseActions';
    acc[responseActionPath].push({
      actionTypeId: _rule_response_actions.ResponseActionTypesEnum['.osquery'],
      params: {
        savedQueryId: undefined,
        packId: undefined,
        queries: undefined,
        query: configuration.query,
        ecsMapping: configuration.ecs_mapping
      }
    });
    return acc;
  }, {
    responseActions: defaultResponseActions
  });
};
exports.getResponseActionsFromNote = getResponseActionsFromNote;