"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ThreatMatchRuleFieldEdit = ThreatMatchRuleFieldEdit;
var _react = _interopRequireDefault(require("react"));
var _utility_types = require("../../../../../../../common/utility_types");
var _kql_query = require("./fields/kql_query");
var _data_source = require("./fields/data_source");
var _alert_suppression = require("./fields/alert_suppression");
var _threat_match_index = require("./fields/threat_match_index");
var _threat_match_query = require("./fields/threat_match_query");
var _threat_match_mapping = require("./fields/threat_match_mapping");
var _threat_index_indicator_path = require("./fields/threat_index_indicator_path");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management/components/rule_details/three_way_diff/final_edit/threat_match_rule_field_edit.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function ThreatMatchRuleFieldEdit({
  fieldName
}) {
  switch (fieldName) {
    case 'kql_query':
      return /*#__PURE__*/_react.default.createElement(_kql_query.KqlQueryEditForm, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 28,
          columnNumber: 14
        }
      });
    case 'data_source':
      return /*#__PURE__*/_react.default.createElement(_data_source.DataSourceEditForm, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 30,
          columnNumber: 14
        }
      });
    case 'alert_suppression':
      return /*#__PURE__*/_react.default.createElement(_alert_suppression.AlertSuppressionEditForm, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 32,
          columnNumber: 14
        }
      });
    case 'threat_index':
      return /*#__PURE__*/_react.default.createElement(_threat_match_index.ThreatMatchIndexEditForm, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 34,
          columnNumber: 14
        }
      });
    case 'threat_query':
      return /*#__PURE__*/_react.default.createElement(_threat_match_query.ThreatMatchQueryEditForm, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 36,
          columnNumber: 14
        }
      });
    case 'threat_mapping':
      return /*#__PURE__*/_react.default.createElement(_threat_match_mapping.ThreatMatchMappingEditForm, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 38,
          columnNumber: 14
        }
      });
    case 'threat_indicator_path':
      return /*#__PURE__*/_react.default.createElement(_threat_index_indicator_path.ThreatMatchIndicatorPathEditForm, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 40,
          columnNumber: 14
        }
      });
    default:
      return (0, _utility_types.assertUnreachable)(fieldName);
  }
}