"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSavedQueryCheckboxLabelWithoutName = exports.getSavedQueryCheckboxLabel = exports.SOURCE = exports.SAVED_QUERY_FORM_ROW_LABEL = exports.RESET_DEFAULT_INDEX = exports.QUERY_BAR_LABEL = exports.MACHINE_LEARNING_SUPPRESSION_INCOMPLETE_LABEL = exports.MACHINE_LEARNING_SUPPRESSION_DISABLED_LABEL = exports.INDEX_HELPER_TEXT = exports.IMPORT_TIMELINE_QUERY = exports.ALERT_SUPPRESSION_FIELDS_TECH_PREVIEW_LABEL_APPEND = exports.ALERT_SUPPRESSION_FIELDS_GA_LABEL_APPEND = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INDEX_HELPER_TEXT = exports.INDEX_HELPER_TEXT = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.indicesHelperDescription', {
  defaultMessage: 'Enter the pattern of Elasticsearch indices where you would like this rule to run. By default, these will include index patterns defined in Security Solution advanced settings.'
});
const RESET_DEFAULT_INDEX = exports.RESET_DEFAULT_INDEX = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.resetDefaultIndicesButton', {
  defaultMessage: 'Reset to default index patterns'
});
const IMPORT_TIMELINE_QUERY = exports.IMPORT_TIMELINE_QUERY = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.importTimelineQueryButton', {
  defaultMessage: 'Import query from saved timeline'
});
const QUERY_BAR_LABEL = exports.QUERY_BAR_LABEL = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.fieldQuerBarLabel', {
  defaultMessage: 'Custom query'
});
const SAVED_QUERY_FORM_ROW_LABEL = exports.SAVED_QUERY_FORM_ROW_LABEL = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.SavedQueryFormRowLabel', {
  defaultMessage: 'Saved query'
});
const getSavedQueryCheckboxLabel = savedQueryName => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.fieldShouldLoadQueryDynamicallyLabel', {
  defaultMessage: 'Load saved query "{savedQueryName}" dynamically on each rule execution',
  values: {
    savedQueryName
  }
});
exports.getSavedQueryCheckboxLabel = getSavedQueryCheckboxLabel;
const getSavedQueryCheckboxLabelWithoutName = () => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.fieldShouldLoadQueryDynamicallyLabelWithoutName', {
  defaultMessage: 'Load saved query dynamically on each rule execution'
});
exports.getSavedQueryCheckboxLabelWithoutName = getSavedQueryCheckboxLabelWithoutName;
const SOURCE = exports.SOURCE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.source', {
  defaultMessage: 'Source'
});
const MACHINE_LEARNING_SUPPRESSION_DISABLED_LABEL = exports.MACHINE_LEARNING_SUPPRESSION_DISABLED_LABEL = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.machineLearningSuppressionDisabledLabel', {
  defaultMessage: 'To enable alert suppression, start relevant Machine Learning jobs.'
});
const MACHINE_LEARNING_SUPPRESSION_INCOMPLETE_LABEL = exports.MACHINE_LEARNING_SUPPRESSION_INCOMPLETE_LABEL = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.machineLearningSuppressionIncompleteLabel', {
  defaultMessage: 'This list of fields might be incomplete as some Machine Learning jobs are not running. Start all relevant jobs for a complete list.'
});
const ALERT_SUPPRESSION_FIELDS_TECH_PREVIEW_LABEL_APPEND = exports.ALERT_SUPPRESSION_FIELDS_TECH_PREVIEW_LABEL_APPEND = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.alertSuppressionTechPreviewLabelAppend', {
  defaultMessage: 'Optional (Technical Preview)'
});
const ALERT_SUPPRESSION_FIELDS_GA_LABEL_APPEND = exports.ALERT_SUPPRESSION_FIELDS_GA_LABEL_APPEND = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.alertSuppressionGALabelAppend', {
  defaultMessage: 'Optional'
});