"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.URL_FORMAT_INVALID = exports.MEDIUM = exports.LOW = exports.LICENSE_FIELD_LABEL = exports.HIGH = exports.GLOBAL_ENDPOINT_EXCEPTION_LIST = exports.FIELD_NOT_EDITABLE_TOOLTIP_TEXT = exports.CRITICAL = exports.BUILDING_BLOCK = exports.AUTHOR_FIELD_LABEL = exports.ADVANCED_SETTINGS = exports.ADD_RULE_SETUP_HELP_TEXT = exports.ADD_RULE_NOTE_HELP_TEXT = exports.ADD_REFERENCE = exports.ADD_FALSE_POSITIVE = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ADVANCED_SETTINGS = exports.ADVANCED_SETTINGS = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepAboutRuleForm.advancedSettingsButton', {
  defaultMessage: 'Advanced settings'
});
const ADD_REFERENCE = exports.ADD_REFERENCE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepAboutRuleForm.addReferenceDescription', {
  defaultMessage: 'Add reference URL'
});
const ADD_FALSE_POSITIVE = exports.ADD_FALSE_POSITIVE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepAboutRuleForm.addFalsePositiveDescription', {
  defaultMessage: 'Add false positive example'
});
const GLOBAL_ENDPOINT_EXCEPTION_LIST = exports.GLOBAL_ENDPOINT_EXCEPTION_LIST = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepAboutRuleForm.endpointExceptionListLabel', {
  defaultMessage: 'Elastic Endpoint exceptions'
});
const BUILDING_BLOCK = exports.BUILDING_BLOCK = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepAboutRuleForm.buildingBlockLabel', {
  defaultMessage: 'Building block'
});
const LOW = exports.LOW = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepAboutRuleForm.severityOptionLowDescription', {
  defaultMessage: 'Low'
});
const MEDIUM = exports.MEDIUM = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepAboutRuleForm.severityOptionMediumDescription', {
  defaultMessage: 'Medium'
});
const HIGH = exports.HIGH = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepAboutRuleForm.severityOptionHighDescription', {
  defaultMessage: 'High'
});
const CRITICAL = exports.CRITICAL = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepAboutRuleForm.severityOptionCriticalDescription', {
  defaultMessage: 'Critical'
});
const URL_FORMAT_INVALID = exports.URL_FORMAT_INVALID = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.referencesUrlInvalidError', {
  defaultMessage: 'URL is invalid format'
});
const ADD_RULE_NOTE_HELP_TEXT = exports.ADD_RULE_NOTE_HELP_TEXT = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepAboutRule.noteHelpText', {
  defaultMessage: 'Add rule investigation guide...'
});
const ADD_RULE_SETUP_HELP_TEXT = exports.ADD_RULE_SETUP_HELP_TEXT = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepAboutRule.addRuleSetupHelpText', {
  defaultMessage: 'Add rule setup guide...'
});
const AUTHOR_FIELD_LABEL = exports.AUTHOR_FIELD_LABEL = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepAboutRule.fieldAuthorLabel', {
  defaultMessage: 'Author'
});
const LICENSE_FIELD_LABEL = exports.LICENSE_FIELD_LABEL = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepAboutRule.fieldLicenseLabel', {
  defaultMessage: 'License'
});
const FIELD_NOT_EDITABLE_TOOLTIP_TEXT = fieldName => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepAboutRule.fieldNotEditableTooltipText', {
  defaultMessage: "{fieldName} can't be edited for Elastic rules.",
  values: {
    fieldName
  }
});
exports.FIELD_NOT_EDITABLE_TOOLTIP_TEXT = FIELD_NOT_EDITABLE_TOOLTIP_TEXT;