"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useShowTimelineForGivenPath = void 0;
var _react = require("react");
var _reactRouterDom = require("react-router-dom");
var _constants = require("../../../data_view_manager/constants");
var _use_data_view = require("../../../data_view_manager/hooks/use_data_view");
var _links_hooks = require("../../links/links_hooks");
var _kibana = require("../../lib/kibana");
var _helpers_access = require("../../../helpers_access");
var _containers = require("../../../sourcerer/containers");
var _use_experimental_features = require("../../hooks/use_experimental_features");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useHiddenTimelineRoutes = () => {
  const normalizedLinks = (0, _links_hooks.useNormalizedAppLinks)();
  const hiddenTimelineRoutes = (0, _react.useMemo)(() => Object.values(normalizedLinks).reduce((acc, link) => {
    if (link.hideTimeline) {
      acc.push(link.path);
    }
    return acc;
  }, []), [normalizedLinks]);
  return hiddenTimelineRoutes;
};
const useShowTimelineForGivenPath = () => {
  const {
    capabilities
  } = (0, _kibana.useKibana)().services.application;
  const userHasSecuritySolutionVisible = (0, _helpers_access.hasAccessToSecuritySolution)(capabilities);
  const {
    indicesExist: oldIndicesExist,
    dataViewId
  } = (0, _containers.useSourcererDataView)(_constants.PageScope.timeline);
  const newDataViewPickerEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newDataViewPickerEnabled');
  const {
    dataView
  } = (0, _use_data_view.useDataView)(_constants.PageScope.timeline);
  const indicesExist = newDataViewPickerEnabled ? dataView.hasMatchedIndices() : oldIndicesExist;
  const hiddenTimelineRoutes = useHiddenTimelineRoutes();
  const isTimelineAllowed = (0, _react.useMemo)(() => {
    // NOTE: with new Data View Picker, data view is always defined
    if (newDataViewPickerEnabled) {
      return userHasSecuritySolutionVisible && indicesExist;
    }
    return userHasSecuritySolutionVisible && (indicesExist || dataViewId === null);
  }, [newDataViewPickerEnabled, userHasSecuritySolutionVisible, indicesExist, dataViewId]);
  const getIsTimelineVisible = (0, _react.useCallback)(pathname => {
    if (!isTimelineAllowed) {
      return false;
    }
    return !hiddenTimelineRoutes.some(route => (0, _reactRouterDom.matchPath)(pathname, route));
  }, [isTimelineAllowed, hiddenTimelineRoutes]);
  return getIsTimelineVisible;
};
exports.useShowTimelineForGivenPath = useShowTimelineForGivenPath;