"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFormFieldMock = exports.kibanaMock = exports.TestProvidersWithPrivileges = exports.TestProvidersComponent = exports.TestProviders = void 0;
var _uiTheme = require("@kbn/ui-theme");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _dnd = require("@hello-pangea/dnd");
var _reactRedux = require("react-redux");
var _styledComponents = require("styled-components");
var _reactQuery = require("@kbn/react-query");
var _cellActions = require("@kbn/cell-actions");
var _provider = require("@kbn/expandable-flyout/src/test/provider");
var _kibana = require("../lib/kibana");
var _upselling_provider = require("../components/upselling_provider");
var _mock_assistant_provider = require("./mock_assistant_provider");
var _console = require("../../management/components/console");
var _kibana_react = require("../lib/kibana/kibana_react.mock");
var _mock_local_storage = require("./mock_local_storage");
var _constants = require("../../../common/constants");
var _user_privileges_context = require("../components/user_privileges/user_privileges_context");
var _discover_in_timeline_provider = require("../components/discover_in_timeline/mocks/discover_in_timeline_provider");
var _create_store = require("./create_store");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/mock/test_providers.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const kibanaMock = exports.kibanaMock = (0, _kibana_react.createStartServicesMock)();
Object.defineProperty(window, 'localStorage', {
  value: (0, _mock_local_storage.localStorageMock)()
});
window.scrollTo = jest.fn();
const MockKibanaContextProvider = (0, _kibana_react.createKibanaContextProviderMock)();

/** A utility for wrapping children in the providers required to run most tests */
const TestProvidersComponent = ({
  children,
  store = (0, _create_store.createMockStore)(),
  startServices,
  onDragEnd = jest.fn(),
  cellActions = []
}) => {
  const queryClient = new _reactQuery.QueryClient({
    defaultOptions: {
      queries: {
        retry: false
      }
    },
    logger: {
      log: jest.fn(),
      warn: jest.fn(),
      error: () => {}
    }
  });
  return /*#__PURE__*/_react.default.createElement(MockKibanaContextProvider, {
    startServices: startServices,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(UpsellingProviderMock, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_reactRedux.Provider, {
    store: store,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_styledComponents.ThemeProvider, {
    theme: () => ({
      eui: _uiTheme.euiDarkVars,
      darkMode: true
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_reactQuery.QueryClientProvider, {
    client: queryClient,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_discover_in_timeline_provider.MockDiscoverInTimelineContext, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_mock_assistant_provider.MockAssistantProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_provider.TestProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_console.ConsoleManager, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_cellActions.CellActionsProvider, {
    getTriggerCompatibleActions: () => Promise.resolve(cellActions),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 25
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiProvider, {
    highContrastMode: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 27
    }
  }, /*#__PURE__*/_react.default.createElement(_dnd.DragDropContext, {
    onDragEnd: onDragEnd,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 29
    }
  }, children)))))))))))));
};
exports.TestProvidersComponent = TestProvidersComponent;
const UpsellingProviderMock = ({
  children
}) => {
  const upselingService = (0, _kibana.useKibana)().services.upselling;
  return /*#__PURE__*/_react.default.createElement(_upselling_provider.UpsellingProvider, {
    upsellingService: upselingService,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 10
    }
  }, children);
};

/**
 * A utility for wrapping children in the providers required to run most tests
 * WITH user privileges provider.
 */
const TestProvidersWithPrivilegesComponent = ({
  children,
  store = (0, _create_store.createMockStore)(),
  onDragEnd = jest.fn(),
  startServices,
  cellActions = []
}) => {
  const queryClient = new _reactQuery.QueryClient({
    defaultOptions: {
      queries: {
        retry: false
      }
    }
  });
  return /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(MockKibanaContextProvider, {
    startServices: startServices,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_reactRedux.Provider, {
    store: store,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_styledComponents.ThemeProvider, {
    theme: () => ({
      eui: _uiTheme.euiDarkVars,
      darkMode: true
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_reactQuery.QueryClientProvider, {
    client: queryClient,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_discover_in_timeline_provider.MockDiscoverInTimelineContext, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_mock_assistant_provider.MockAssistantProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_user_privileges_context.UserPrivilegesProvider, {
    kibanaCapabilities: {
      [_constants.SECURITY_FEATURE_ID]: {
        show: true,
        crud: true
      },
      [_constants.CASES_FEATURE_ID]: {
        read_cases: true,
        crud_cases: false
      },
      [_constants.ASSISTANT_FEATURE_ID]: {
        'ai-assistant': true
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_cellActions.CellActionsProvider, {
    getTriggerCompatibleActions: () => Promise.resolve(cellActions),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiProvider, {
    highContrastMode: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_dnd.DragDropContext, {
    onDragEnd: onDragEnd,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 25
    }
  }, children)))))))))));
};
const TestProviders = exports.TestProviders = /*#__PURE__*/_react.default.memo(TestProvidersComponent);
const TestProvidersWithPrivileges = exports.TestProvidersWithPrivileges = /*#__PURE__*/_react.default.memo(TestProvidersWithPrivilegesComponent);
const useFormFieldMock = options => {
  return {
    path: 'path',
    type: 'type',
    value: 'mockedValue',
    isPristine: false,
    isDirty: false,
    isModified: false,
    isValidating: false,
    isValidated: false,
    isChangingValue: false,
    errors: [],
    isValid: true,
    getErrorsMessages: jest.fn(),
    onChange: jest.fn(),
    setValue: jest.fn(),
    setErrors: jest.fn(),
    clearErrors: jest.fn(),
    validate: jest.fn(),
    reset: jest.fn(),
    __isIncludedInOutput: true,
    __serializeValue: jest.fn(),
    ...options
  };
};
exports.useFormFieldMock = useFormFieldMock;