"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useConnectors = void 0;
var _react = require("react");
var _hooks = require("@kbn/response-ops-rule-form/src/common/hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useConnectors = ({
  http
}) => {
  const [currentConnector, setCurrentConnector] = (0, _react.useState)(null);
  const {
    data: allConnectors,
    isLoading: isLoadingAllConnectors
  } = (0, _hooks.useLoadConnectors)({
    http
  });
  const connectors = (0, _react.useMemo)(() => {
    if (!isLoadingAllConnectors && allConnectors) {
      if (currentConnector && !allConnectors.some(connector => connector.id === currentConnector.id)) {
        return [...allConnectors, currentConnector];
      }
      return allConnectors;
    }
    return currentConnector ? [currentConnector] : [];
  }, [currentConnector, isLoadingAllConnectors, allConnectors]);
  return {
    connectors,
    setCurrentConnector
  };
};
exports.useConnectors = useConnectors;