"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateMustache = exports.validateActionParams = exports.getActionTypeName = void 0;
var _mustache = _interopRequireDefault(require("mustache"));
var _fp = require("lodash/fp");
var I18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getActionTypeName = actionTypeId => {
  if (!actionTypeId) return '';
  const actionType = actionTypeId.split('.')[1];
  if (!actionType) return '';
  return (0, _fp.startCase)(actionType);
};
exports.getActionTypeName = getActionTypeName;
const validateMustache = params => {
  const errors = [];
  Object.entries(params).forEach(([paramKey, paramValue]) => {
    if (!(0, _fp.isString)(paramValue)) return;
    try {
      _mustache.default.render(paramValue, {});
    } catch (e) {
      errors.push(I18n.INVALID_MUSTACHE_TEMPLATE(paramKey));
    }
  });
  return errors;
};
exports.validateMustache = validateMustache;
const validateActionParams = async (actionItem, actionTypeRegistry, connector) => {
  var _actionTypeRegistry$g;
  const connectorConfig = connector && 'config' in connector ? connector.config : undefined;
  const actionErrors = await ((_actionTypeRegistry$g = actionTypeRegistry.get(actionItem.actionTypeId)) === null || _actionTypeRegistry$g === void 0 ? void 0 : _actionTypeRegistry$g.validateParams(actionItem.params, connectorConfig));
  if (actionErrors) {
    const actionErrorsValues = Object.values(actionErrors.errors);
    if (actionErrorsValues.length) {
      const filteredObjects = actionErrorsValues.filter(item => (0, _fp.isString)(item) || (0, _fp.isArray)(item));
      const uniqActionErrors = (0, _fp.uniq)((0, _fp.flattenDeep)(filteredObjects));
      if (uniqActionErrors.length) {
        return uniqActionErrors;
      }
    }
  }
  return [];
};
exports.validateActionParams = validateActionParams;