"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PluginTemplateWrapper = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _kibana = require("../../lib/kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/plugin_template_wrapper/plugin_template_wrapper.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Uses securityLayout service to retrieve shared plugin wrapper component and renders plugin routes / children inside of it.
 *
 * The `template` prop can be used to alter the page layout for a given plugin route / all routes within a plugin - depending on the nesting.
 */
const PluginTemplateWrapper = exports.PluginTemplateWrapper = /*#__PURE__*/_react.default.memo(({
  children,
  ...rest
}) => {
  const {
    services: {
      securityLayout: {
        getPluginWrapper
      }
    }
  } = (0, _kibana.useKibana)();
  const Wrapper = (0, _react.useMemo)(() => getPluginWrapper(), [getPluginWrapper]);
  return /*#__PURE__*/_react.default.createElement(Wrapper, (0, _extends2.default)({}, rest, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 28,
      columnNumber: 12
    }
  }), children);
});
PluginTemplateWrapper.displayName = 'PluginTemplateWrapper';