"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Ja3FingerprintLink = exports.HostDetailsLink = exports.GoogleLink = exports.ExternalLink = exports.EntityDetailsLink = exports.DEFAULT_NUMBER_OF_LINK = exports.DEFAULT_MORE_MAX_HEIGHT = exports.CreateCaseLink = exports.CertificateFingerprintLink = exports.CaseDetailsLink = void 0;
Object.defineProperty(exports, "LinkAnchor", {
  enumerable: true,
  get: function () {
    return _helpers2.LinkAnchor;
  }
});
Object.defineProperty(exports, "LinkButton", {
  enumerable: true,
  get: function () {
    return _helpers2.LinkButton;
  }
});
exports.WhoIsLink = exports.UserDetailsLink = exports.ServiceDetailsLink = exports.SecuritySolutionLinkButton = exports.SecuritySolutionLinkAnchor = exports.ReputationLink = exports.PortOrServiceNameLink = exports.NetworkDetailsLink = void 0;
Object.defineProperty(exports, "useGetSecuritySolutionLinkProps", {
  enumerable: true,
  get: function () {
    return _link_props.useGetSecuritySolutionLinkProps;
  }
});
Object.defineProperty(exports, "useSecuritySolutionLinkProps", {
  enumerable: true,
  get: function () {
    return _link_props.useSecuritySolutionLinkProps;
  }
});
Object.defineProperty(exports, "withSecuritySolutionLink", {
  enumerable: true,
  get: function () {
    return _link_props.withSecuritySolutionLink;
  }
});
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _fp = require("lodash/fp");
var _types = require("../../../../common/entity_analytics/types");
var _constants = require("../../../../common/constants");
var _helpers = require("../../lib/helpers");
var _link_to = require("../link_to");
var _network = require("../../../../common/search_strategy/security_solution/network");
var _kibana = require("../../lib/kibana");
var _validators = require("../../utils/validators");
var i18n = _interopRequireWildcard(require("./translations"));
var _types2 = require("../../../app/types");
var _redirect_to_users = require("../link_to/redirect_to_users");
var _helpers2 = require("./helpers");
var _link_props = require("./link_props");
var _telemetry = require("../../lib/telemetry");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/links/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DEFAULT_NUMBER_OF_LINK = exports.DEFAULT_NUMBER_OF_LINK = 5;

/** The default max-height of the Reputation Links popover used to show "+n More" items (e.g. `+9 More`) */
const DEFAULT_MORE_MAX_HEIGHT = exports.DEFAULT_MORE_MAX_HEIGHT = '200px';

// Internal Links
const UserDetailsLinkComponent = ({
  children,
  Component,
  userName,
  isButton,
  onClick: onClickParam,
  title,
  userTab
}) => {
  const encodedUserName = encodeURIComponent(userName);
  const {
    formatUrl,
    search
  } = (0, _link_to.useFormatUrl)(_types2.SecurityPageName.users);
  const {
    application: {
      navigateToApp
    },
    telemetry
  } = (0, _kibana.useKibana)().services;
  const goToUsersDetails = (0, _react.useCallback)(ev => {
    ev.preventDefault();
    navigateToApp(_constants.APP_UI_ID, {
      deepLinkId: _types2.SecurityPageName.users,
      path: userTab ? (0, _redirect_to_users.getTabsOnUsersDetailsUrl)(encodedUserName, userTab, search) : (0, _redirect_to_users.getUsersDetailsUrl)(encodedUserName, search)
    });
  }, [encodedUserName, navigateToApp, search, userTab]);
  const href = (0, _react.useMemo)(() => formatUrl(userTab ? (0, _redirect_to_users.getTabsOnUsersDetailsUrl)(encodedUserName, userTab) : (0, _redirect_to_users.getUsersDetailsUrl)(encodedUserName)), [formatUrl, encodedUserName, userTab]);
  const onClick = (0, _react.useCallback)(e => {
    telemetry.reportEvent(_telemetry.EntityEventTypes.EntityDetailsClicked, {
      entity: _types.EntityType.user
    });
    const callback = onClickParam !== null && onClickParam !== void 0 ? onClickParam : goToUsersDetails;
    callback(e);
  }, [goToUsersDetails, onClickParam, telemetry]);
  return isButton ? /*#__PURE__*/_react.default.createElement(_helpers2.GenericLinkButton, {
    Component: Component,
    dataTestSubj: "data-grid-user-details",
    href: href,
    onClick: onClick,
    title: title !== null && title !== void 0 ? title : userName,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 5
    }
  }, children ? children : userName) : /*#__PURE__*/_react.default.createElement(_helpers2.LinkAnchor, {
    "data-test-subj": "users-link-anchor",
    onClick: onClick,
    href: href,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 5
    }
  }, children ? children : userName);
};
const UserDetailsLink = exports.UserDetailsLink = /*#__PURE__*/_react.default.memo(UserDetailsLinkComponent);
const ServiceDetailsLinkComponent = ({
  children,
  onClick: onClickParam,
  serviceName
}) => {
  const {
    telemetry
  } = (0, _kibana.useKibana)().services;
  const onClick = (0, _react.useCallback)(e => {
    telemetry.reportEvent(_telemetry.EntityEventTypes.EntityDetailsClicked, {
      entity: _types.EntityType.service
    });
    if (onClickParam) {
      onClickParam(e);
    }
  }, [onClickParam, telemetry]);
  return onClickParam ? /*#__PURE__*/_react.default.createElement(_helpers2.LinkAnchor, {
    "data-test-subj": "service-link-anchor",
    onClick: onClick,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 5
    }
  }, children ? children : serviceName) : serviceName;
};
const ServiceDetailsLink = exports.ServiceDetailsLink = /*#__PURE__*/_react.default.memo(ServiceDetailsLinkComponent);
const HostDetailsLinkComponent = ({
  children,
  Component,
  hostName,
  isButton,
  onClick: onClickParam,
  title,
  hostTab
}) => {
  const {
    formatUrl,
    search
  } = (0, _link_to.useFormatUrl)(_types2.SecurityPageName.hosts);
  const {
    application: {
      navigateToApp
    },
    telemetry
  } = (0, _kibana.useKibana)().services;
  const encodedHostName = encodeURIComponent(hostName);
  const goToHostDetails = (0, _react.useCallback)(ev => {
    ev.preventDefault();
    navigateToApp(_constants.APP_UI_ID, {
      deepLinkId: _types2.SecurityPageName.hosts,
      path: hostTab ? (0, _link_to.getTabsOnHostDetailsUrl)(encodedHostName, hostTab, search) : (0, _link_to.getHostDetailsUrl)(encodedHostName, search)
    });
  }, [encodedHostName, navigateToApp, search, hostTab]);
  const href = (0, _react.useMemo)(() => formatUrl(hostTab ? (0, _link_to.getTabsOnHostDetailsUrl)(encodedHostName, hostTab) : (0, _link_to.getHostDetailsUrl)(encodedHostName)), [formatUrl, encodedHostName, hostTab]);
  const onClick = (0, _react.useCallback)(e => {
    telemetry.reportEvent(_telemetry.EntityEventTypes.EntityDetailsClicked, {
      entity: _types.EntityType.host
    });
    const callback = onClickParam !== null && onClickParam !== void 0 ? onClickParam : goToHostDetails;
    callback(e);
  }, [goToHostDetails, onClickParam, telemetry]);
  return isButton ? /*#__PURE__*/_react.default.createElement(_helpers2.GenericLinkButton, {
    Component: Component,
    dataTestSubj: "data-grid-host-details",
    href: href,
    iconType: "expand",
    onClick: onClick,
    title: title !== null && title !== void 0 ? title : hostName,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 213,
      columnNumber: 5
    }
  }, children) : /*#__PURE__*/_react.default.createElement(_helpers2.LinkAnchor, {
    onClick: onClick,
    href: href,
    "data-test-subj": "host-details-button",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 224,
      columnNumber: 5
    }
  }, children ? children : hostName);
};
const HostDetailsLink = exports.HostDetailsLink = /*#__PURE__*/_react.default.memo(HostDetailsLinkComponent);
const EntityDetailsLink = ({
  entityType,
  tab,
  entityName,
  ...props
}) => {
  if (entityType === _types.EntityType.host) {
    return /*#__PURE__*/_react.default.createElement(HostDetailsLink, (0, _extends2.default)({}, props, {
      hostTab: tab,
      hostName: entityName,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 250,
        columnNumber: 12
      }
    }));
  } else if (entityType === _types.EntityType.user) {
    return /*#__PURE__*/_react.default.createElement(UserDetailsLink, (0, _extends2.default)({}, props, {
      userTab: tab,
      userName: entityName,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 252,
        columnNumber: 12
      }
    }));
  } else if (entityType === _types.EntityType.service) {
    return /*#__PURE__*/_react.default.createElement(ServiceDetailsLink, {
      serviceName: entityName,
      onClick: props.onClick,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 254,
        columnNumber: 12
      }
    });
  }
  return entityName;
};
exports.EntityDetailsLink = EntityDetailsLink;
const allowedUrlSchemes = ['http://', 'https://'];
const ExternalLink = exports.ExternalLink = /*#__PURE__*/_react.default.memo(({
  url,
  children,
  idx,
  overflowIndexStart = DEFAULT_NUMBER_OF_LINK,
  allItemsLimit = DEFAULT_NUMBER_OF_LINK
}) => {
  const lastVisibleItemIndex = overflowIndexStart - 1;
  const lastItemIndex = allItemsLimit - 1;
  const lastIndexToShow = Math.max(0, Math.min(lastVisibleItemIndex, lastItemIndex));
  const inAllowlist = allowedUrlSchemes.some(scheme => url.indexOf(scheme) === 0);
  return url && inAllowlist && !(0, _validators.isUrlInvalid)(url) && children ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: url,
    position: "top",
    "data-test-subj": "externalLinkTooltip",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 280,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: url,
    target: "_blank",
    rel: "noopener",
    "data-test-subj": "externalLink",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 282,
      columnNumber: 11
    }
  }, children), !(0, _fp.isNil)(idx) && idx < lastIndexToShow && /*#__PURE__*/_react.default.createElement(_helpers2.Comma, {
    "data-test-subj": "externalLinkComma",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 285,
      columnNumber: 52
    }
  }))) : null;
});
ExternalLink.displayName = 'ExternalLink';
const NetworkDetailsLinkComponent = ({
  ip,
  ...restProps
}) => {
  // We see that sometimes the `ip` is passed as a string value of "IP1,IP2".
  // Therefore we're breaking up this string into individual IPs first.
  const actualIp = (0, _react.useMemo)(() => {
    if (typeof ip === 'string' && ip.includes(',')) {
      return ip.split(',').map(str => str.trim());
    } else {
      return ip;
    }
  }, [ip]);
  return (0, _fp.isArray)(actualIp) ? actualIp.map((currentIp, index) => /*#__PURE__*/_react.default.createElement("span", {
    key: `${currentIp}-${index}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 318,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(IpLinkComponent, (0, _extends2.default)({
    ip: currentIp
  }, restProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 319,
      columnNumber: 9
    }
  })), index === actualIp.length - 1 ? '' : ', ')) : /*#__PURE__*/_react.default.createElement(IpLinkComponent, (0, _extends2.default)({
    ip: actualIp
  }, restProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 324,
      columnNumber: 5
    }
  }));
};
const NetworkDetailsLink = exports.NetworkDetailsLink = /*#__PURE__*/_react.default.memo(NetworkDetailsLinkComponent);
const IpLinkComponent = ({
  isButton,
  onClick,
  ip: ipAddress,
  flowTarget = _network.FlowTarget.source,
  Component,
  title,
  children
}) => {
  const getSecuritySolutionLinkProps = (0, _link_props.useGetSecuritySolutionLinkProps)();
  const {
    onClick: onClickNavigation,
    href
  } = getSecuritySolutionLinkProps({
    deepLinkId: _types2.SecurityPageName.network,
    path: (0, _link_to.getNetworkDetailsUrl)(encodeURIComponent((0, _helpers.encodeIpv6)(ipAddress)), flowTarget)
  });
  const onLinkClick = (0, _react.useCallback)(e => {
    if (onClick) {
      e.preventDefault();
      onClick(ipAddress);
    } else {
      onClickNavigation(e);
    }
  }, [onClick, onClickNavigation, ipAddress]);
  return isButton ? /*#__PURE__*/_react.default.createElement(_helpers2.GenericLinkButton, {
    Component: Component,
    key: ipAddress,
    dataTestSubj: "data-grid-network-details",
    onClick: onLinkClick,
    href: href,
    title: title !== null && title !== void 0 ? title : ipAddress,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 360,
      columnNumber: 5
    }
  }, children) : /*#__PURE__*/_react.default.createElement(_helpers2.LinkAnchor, {
    key: ipAddress,
    onClick: onLinkClick,
    href: href,
    "data-test-subj": "network-details",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 371,
      columnNumber: 5
    }
  }, children ? children : ipAddress);
};
const CaseDetailsLinkComponent = ({
  children,
  detailName,
  title,
  openInNewTab = false
}) => {
  const {
    formatUrl,
    search
  } = (0, _link_to.useFormatUrl)(_types2.SecurityPageName.case);
  const {
    navigateToApp
  } = (0, _kibana.useKibana)().services.application;
  const goToCaseDetails = (0, _react.useCallback)(async ev => {
    if (ev) ev.preventDefault();
    return navigateToApp(_constants.APP_UI_ID, {
      deepLinkId: _types2.SecurityPageName.case,
      path: (0, _link_to.getCaseDetailsUrl)({
        id: detailName,
        search
      }),
      openInNewTab
    });
  }, [detailName, navigateToApp, openInNewTab, search]);
  return /*#__PURE__*/_react.default.createElement(_helpers2.LinkAnchor, {
    onClick: goToCaseDetails,
    href: formatUrl((0, _link_to.getCaseDetailsUrl)({
      id: detailName
    })),
    "data-test-subj": "case-details-link",
    "aria-label": i18n.CASE_DETAILS_LINK_ARIA(title !== null && title !== void 0 ? title : detailName),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 415,
      columnNumber: 5
    }
  }, children ? children : detailName);
};
const CaseDetailsLink = exports.CaseDetailsLink = /*#__PURE__*/_react.default.memo(CaseDetailsLinkComponent);
CaseDetailsLink.displayName = 'CaseDetailsLink';
const CreateCaseLink = exports.CreateCaseLink = /*#__PURE__*/_react.default.memo(({
  children
}) => {
  const {
    formatUrl,
    search
  } = (0, _link_to.useFormatUrl)(_types2.SecurityPageName.case);
  const {
    navigateToApp
  } = (0, _kibana.useKibana)().services.application;
  const goToCreateCase = (0, _react.useCallback)(async ev => {
    ev.preventDefault();
    return navigateToApp(_constants.APP_UI_ID, {
      deepLinkId: _types2.SecurityPageName.case,
      path: (0, _link_to.getCreateCaseUrl)(search)
    });
  }, [navigateToApp, search]);
  return /*#__PURE__*/_react.default.createElement(_helpers2.LinkAnchor, {
    onClick: goToCreateCase,
    href: formatUrl((0, _link_to.getCreateCaseUrl)()),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 442,
      columnNumber: 5
    }
  }, children);
});
CreateCaseLink.displayName = 'CreateCaseLink';

// External Links
const GoogleLink = exports.GoogleLink = /*#__PURE__*/_react.default.memo(({
  children,
  link
}) => {
  const url = (0, _react.useMemo)(() => `https://www.google.com/search?q=${encodeURIComponent(link)}`, [link]);
  return /*#__PURE__*/_react.default.createElement(ExternalLink, {
    url: url,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 457,
      columnNumber: 12
    }
  }, children ? children : link);
});
GoogleLink.displayName = 'GoogleLink';
const PortOrServiceNameLink = exports.PortOrServiceNameLink = /*#__PURE__*/_react.default.memo(({
  Component,
  title,
  children,
  portOrServiceName
}) => {
  var _ref;
  const href = (0, _react.useMemo)(() => `https://www.iana.org/assignments/service-names-port-numbers/service-names-port-numbers.xhtml?search=${encodeURIComponent(String(portOrServiceName))}`, [portOrServiceName]);
  return Component ? /*#__PURE__*/_react.default.createElement(Component, {
    href: href,
    "data-test-subj": "data-grid-port-or-service-name-link",
    title: title,
    iconType: "link",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 479,
      columnNumber: 5
    }
  }, (_ref = title !== null && title !== void 0 ? title : children) !== null && _ref !== void 0 ? _ref : portOrServiceName) : /*#__PURE__*/_react.default.createElement(_helpers2.PortContainer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 488,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "port-or-service-name-link",
    href: href,
    target: "_blank",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 489,
      columnNumber: 7
    }
  }, children ? children : portOrServiceName));
});
PortOrServiceNameLink.displayName = 'PortOrServiceNameLink';
const Ja3FingerprintLink = exports.Ja3FingerprintLink = /*#__PURE__*/_react.default.memo(({
  children,
  ja3Fingerprint
}) => {
  const href = (0, _react.useMemo)(() => `https://sslbl.abuse.ch/ja3-fingerprints/${encodeURIComponent(ja3Fingerprint)}`, [ja3Fingerprint]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "ja3-fingerprint-link",
    href: href,
    target: "_blank",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 507,
      columnNumber: 5
    }
  }, children ? children : ja3Fingerprint);
});
Ja3FingerprintLink.displayName = 'Ja3FingerprintLink';
const CertificateFingerprintLink = exports.CertificateFingerprintLink = /*#__PURE__*/_react.default.memo(({
  children,
  certificateFingerprint
}) => {
  const href = (0, _react.useMemo)(() => `https://sslbl.abuse.ch/ssl-certificates/sha1/${encodeURIComponent(certificateFingerprint)}`, [certificateFingerprint]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "certificate-fingerprint-link",
    href: href,
    target: "_blank",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 525,
      columnNumber: 5
    }
  }, children ? children : certificateFingerprint);
});
CertificateFingerprintLink.displayName = 'CertificateFingerprintLink';
var DefaultReputationLink = /*#__PURE__*/function (DefaultReputationLink) {
  DefaultReputationLink["virustotal.com"] = "virustotal.com";
  DefaultReputationLink["talosIntelligence.com"] = "talosIntelligence.com";
  return DefaultReputationLink;
}(DefaultReputationLink || {});
function isDefaultReputationLink(name) {
  return name === DefaultReputationLink['virustotal.com'] || name === DefaultReputationLink['talosIntelligence.com'];
}
const isReputationLink = rowItem => rowItem.url_template !== undefined && rowItem.name !== undefined;
const defaultNameMapping = {
  [DefaultReputationLink['virustotal.com']]: i18n.VIEW_VIRUS_TOTAL,
  [DefaultReputationLink['talosIntelligence.com']]: i18n.VIEW_TALOS_INTELLIGENCE
};
const ReputationLinkComponent = ({
  overflowIndexStart = DEFAULT_NUMBER_OF_LINK,
  allItemsLimit = DEFAULT_NUMBER_OF_LINK,
  showDomain = false,
  domain,
  direction = 'row'
}) => {
  const [ipReputationLinksSetting] = (0, _kibana.useUiSetting$)(_constants.IP_REPUTATION_LINKS_SETTING);
  const ipReputationLinks = (0, _react.useMemo)(() => ipReputationLinksSetting === null || ipReputationLinksSetting === void 0 ? void 0 : ipReputationLinksSetting.slice(0, allItemsLimit).filter(
  // eslint-disable-next-line @typescript-eslint/naming-convention
  ({
    url_template,
    name
  }) => !(0, _fp.isNil)(url_template) && !(0, _fp.isNil)(name) && !(0, _validators.isUrlInvalid)(url_template))
  // eslint-disable-next-line @typescript-eslint/naming-convention
  .map(({
    name,
    url_template
  }) => ({
    name: isDefaultReputationLink(name) ? defaultNameMapping[name] : name,
    url_template: url_template.replace(`{{ip}}`, encodeURIComponent(domain))
  })),
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [ipReputationLinksSetting, domain, defaultNameMapping, allItemsLimit]);
  const renderCallback = (0, _react.useCallback)(rowItem => {
    var _rowItem$name;
    return isReputationLink(rowItem) && /*#__PURE__*/_react.default.createElement(ExternalLink, {
      url: rowItem.url_template,
      overflowIndexStart: overflowIndexStart,
      allItemsLimit: allItemsLimit,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 593,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, (_rowItem$name = rowItem.name) !== null && _rowItem$name !== void 0 ? _rowItem$name : domain));
  }, [allItemsLimit, domain, overflowIndexStart]);
  return (ipReputationLinks === null || ipReputationLinks === void 0 ? void 0 : ipReputationLinks.length) > 0 ? /*#__PURE__*/_react.default.createElement("section", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 605,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    justifyContent: "center",
    direction: direction,
    alignItems: "center",
    "data-test-subj": "reputationLinkGroup",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 606,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 613,
      columnNumber: 9
    }
  }, ipReputationLinks === null || ipReputationLinks === void 0 ? void 0 : ipReputationLinks.slice(0, overflowIndexStart).map(({
    name,
    url_template: urlTemplate
  }, id) => /*#__PURE__*/_react.default.createElement(ExternalLink, {
    allItemsLimit: ipReputationLinks.length,
    idx: id,
    overflowIndexStart: overflowIndexStart,
    url: urlTemplate,
    key: `reputationLink-${id}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 617,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, showDomain ? domain : name !== null && name !== void 0 ? name : domain)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 629,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_helpers2.ReputationLinksOverflow, {
    rowItems: ipReputationLinks,
    render: renderCallback,
    moreMaxHeight: DEFAULT_MORE_MAX_HEIGHT,
    overflowIndexStart: overflowIndexStart,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 630,
      columnNumber: 11
    }
  })))) : null;
};
ReputationLinkComponent.displayName = 'ReputationLinkComponent';
const ReputationLink = exports.ReputationLink = /*#__PURE__*/_react.default.memo(ReputationLinkComponent);
const WhoIsLink = exports.WhoIsLink = /*#__PURE__*/_react.default.memo(({
  children,
  domain
}) => {
  const url = (0, _react.useMemo)(() => `https://www.iana.org/whois?q=${encodeURIComponent(domain)}`, [domain]);
  return /*#__PURE__*/_react.default.createElement(ExternalLink, {
    url: url,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 652,
      columnNumber: 12
    }
  }, children ? children : domain);
});
WhoIsLink.displayName = 'WhoIsLink';

/**
 * Security Solutions internal link button.
 *
 * `<SecuritySolutionLinkButton deepLinkId={SecurityPageName.hosts} />;`
 */
const SecuritySolutionLinkButton = exports.SecuritySolutionLinkButton = (0, _link_props.withSecuritySolutionLink)(_helpers2.LinkButton);

/**
 * Security Solutions internal link anchor.
 *
 * `<SecuritySolutionLinkAnchor deepLinkId={SecurityPageName.hosts} />;`
 */
const SecuritySolutionLinkAnchor = exports.SecuritySolutionLinkAnchor = (0, _link_props.withSecuritySolutionLink)(_helpers2.LinkAnchor);