"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReputationLinksOverflow = exports.PortContainer = exports.MoreReputationLinksContainer = exports.LinkButton = exports.LinkAnchor = exports.GenericLinkButton = exports.Comma = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _i18nReact = require("@kbn/i18n-react");
var _empty_value = require("../empty_value");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/links/helpers.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const LinkButton = ({
  children,
  ...props
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({}, props, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 33,
    columnNumber: 33
  }
}), children);
exports.LinkButton = LinkButton;
const LinkAnchor = ({
  children,
  ...props
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _extends2.default)({}, props, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 36,
    columnNumber: 3
  }
}), children);
exports.LinkAnchor = LinkAnchor;
const Comma = exports.Comma = (0, _styled.default)('span')`
  margin-right: 5px;
  margin-left: 5px;
  &::after {
    content: ' ,';
  }
`;
Comma.displayName = 'Comma';
const GenericLinkButtonComponent = ({
  children,
  Component,
  dataTestSubj,
  href,
  onClick,
  title,
  iconType = 'expand'
}) => {
  return Component ? /*#__PURE__*/_react.default.createElement(Component, {
    "data-test-subj": dataTestSubj,
    href: href,
    iconType: iconType,
    onClick: onClick,
    title: title,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 5
    }
  }, title !== null && title !== void 0 ? title : children) : /*#__PURE__*/_react.default.createElement(LinkButton, {
    "data-test-subj": dataTestSubj,
    href: href,
    onClick: onClick,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 5
    }
  }, title !== null && title !== void 0 ? title : children);
};
const GenericLinkButton = exports.GenericLinkButton = /*#__PURE__*/_react.default.memo(GenericLinkButtonComponent);
const PortContainer = exports.PortContainer = _styled.default.div`
  & svg {
    position: relative;
    top: -1px;
  }
`;
const ReputationLinksOverflow = exports.ReputationLinksOverflow = /*#__PURE__*/_react.default.memo(({
  moreMaxHeight,
  overflowIndexStart = 5,
  render,
  rowItems
}) => {
  const [isOpen, setIsOpen] = (0, _react.useState)(false);
  const togglePopover = (0, _react.useCallback)(() => setIsOpen(currentIsOpen => !currentIsOpen), []);
  const button = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, ' ,', /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "xs",
    onClick: togglePopover,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 11
    }
  }, `+${rowItems.length - overflowIndexStart} `, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.reputationLinks.moreLabel",
    defaultMessage: "More",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 13
    }
  }))), [togglePopover, overflowIndexStart, rowItems.length]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 7
    }
  }, rowItems.length > overflowIndexStart && /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "popover",
    button: button,
    isOpen: isOpen,
    closePopover: togglePopover,
    repositionOnScroll: true,
    panelClassName: "withHoverActions__popover",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(MoreReputationLinksContainer, {
    render: render,
    rowItems: rowItems,
    moreMaxHeight: moreMaxHeight,
    overflowIndexStart: overflowIndexStart,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 13
    }
  })));
});
ReputationLinksOverflow.displayName = 'ReputationLinksOverflow';
const MoreReputationLinksContainer = exports.MoreReputationLinksContainer = /*#__PURE__*/_react.default.memo(({
  moreMaxHeight,
  overflowIndexStart,
  render,
  rowItems
}) => {
  const moreItems = (0, _react.useMemo)(() => rowItems.slice(overflowIndexStart).map((rowItem, index) => {
    var _ref;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: 1,
      key: `${rowItem}-${index}`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 144,
        columnNumber: 13
      }
    }, (_ref = render && render(rowItem)) !== null && _ref !== void 0 ? _ref : (0, _empty_value.defaultToEmptyTag)(rowItem));
  }), [overflowIndexStart, render, rowItems]);
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "more-container",
    className: "eui-yScroll",
    style: {
      maxHeight: moreMaxHeight
    },
    css: {
      paddingRight: '2px'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    direction: "column",
    "data-test-subj": "overflow-items",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 9
    }
  }, moreItems));
});
MoreReputationLinksContainer.displayName = 'MoreReputationLinksContainer';