"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RowAction = void 0;
var _react = _interopRequireWildcard(require("react"));
var _expandableFlyout = require("@kbn/expandable-flyout");
var _left = require("../../../../flyout/document_details/left");
var _kibana = require("../../../lib/kibana");
var _panel_keys = require("../../../../flyout/document_details/shared/constants/panel_keys");
var _telemetry = require("../../../lib/telemetry");
var _get_mapped_non_ecs_value = require("../../../utils/get_mapped_non_ecs_value");
var _user_privileges = require("../../user_privileges");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/control_columns/row_action/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const RowActionComponent = ({
  columnHeaders,
  controlColumn,
  data,
  disabled,
  index,
  isEventViewer,
  loadingEventIds,
  onRowSelected,
  onRuleChange,
  pageRowIndex,
  refetch,
  rowIndex,
  selectedEventIds,
  setEventsLoading,
  setEventsDeleted,
  showCheckboxes,
  tabType,
  tableId,
  width
}) => {
  const {
    data: timelineNonEcsData,
    ecs: ecsData,
    _id: eventId,
    _index: indexName
  } = data !== null && data !== void 0 ? data : {};
  const {
    telemetry
  } = (0, _kibana.useKibana)().services;
  const {
    openFlyout
  } = (0, _expandableFlyout.useExpandableFlyoutApi)();
  const columnValues = (0, _react.useMemo)(() => timelineNonEcsData && columnHeaders.map(header => {
    var _getMappedNonEcsValue;
    return (_getMappedNonEcsValue = (0, _get_mapped_non_ecs_value.getMappedNonEcsValue)({
      data: timelineNonEcsData,
      fieldName: header.id
    })) !== null && _getMappedNonEcsValue !== void 0 ? _getMappedNonEcsValue : [];
  }).join(' '), [columnHeaders, timelineNonEcsData]);
  const {
    notesPrivileges: {
      read: canReadNotes
    },
    timelinePrivileges: {
      read: canReadTimelines
    }
  } = (0, _user_privileges.useUserPrivileges)();
  const showNotes = canReadNotes;
  const handleOnEventDetailPanelOpened = (0, _react.useCallback)(() => {
    openFlyout({
      right: {
        id: _panel_keys.DocumentDetailsRightPanelKey,
        params: {
          id: eventId,
          indexName,
          scopeId: tableId
        }
      }
    });
    telemetry.reportEvent(_telemetry.DocumentEventTypes.DetailsFlyoutOpened, {
      location: tableId,
      panel: 'right'
    });
  }, [eventId, indexName, tableId, openFlyout, telemetry]);
  const toggleShowNotes = (0, _react.useCallback)(() => {
    openFlyout({
      right: {
        id: _panel_keys.DocumentDetailsRightPanelKey,
        params: {
          id: eventId,
          indexName,
          scopeId: tableId
        }
      },
      left: {
        id: _panel_keys.DocumentDetailsLeftPanelKey,
        path: {
          tab: _left.LeftPanelNotesTab
        },
        params: {
          id: eventId,
          indexName,
          scopeId: tableId
        }
      }
    });
    telemetry.reportEvent(_telemetry.NotesEventTypes.OpenNoteInExpandableFlyoutClicked, {
      location: tableId
    });
    telemetry.reportEvent(_telemetry.DocumentEventTypes.DetailsFlyoutOpened, {
      location: tableId,
      panel: 'left'
    });
  }, [eventId, indexName, openFlyout, tableId, telemetry]);
  const Action = controlColumn.rowCellRender;
  if (!timelineNonEcsData || !ecsData || !eventId) {
    return /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "noData",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 146,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, Action && /*#__PURE__*/_react.default.createElement(Action, {
    ariaRowindex: pageRowIndex + 1,
    checked: Object.keys(selectedEventIds).includes(eventId),
    columnId: controlColumn.id || '',
    columnValues: columnValues || '',
    "data-test-subj": "actions",
    disabled: disabled,
    disableTimelineAction: !canReadTimelines,
    ecsData: ecsData,
    eventId: eventId,
    index: index,
    isEventViewer: isEventViewer,
    loadingEventIds: loadingEventIds,
    onEventDetailsPanelOpened: handleOnEventDetailPanelOpened,
    onRowSelected: onRowSelected,
    onRuleChange: onRuleChange,
    refetch: refetch,
    rowIndex: rowIndex,
    setEventsLoading: setEventsLoading,
    setEventsDeleted: setEventsDeleted,
    showCheckboxes: showCheckboxes,
    showNotes: showNotes,
    tabType: tabType,
    timelineId: tableId,
    toggleShowNotes: toggleShowNotes,
    width: width,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 9
    }
  }));
};
const RowAction = exports.RowAction = /*#__PURE__*/_react.default.memo(RowActionComponent);