"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.securityTelemetry = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _api = require("@opentelemetry/api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class SecurityTelemetry {
  constructor() {
    (0, _defineProperty2.default)(this, "meter", _api.metrics.getMeter('kibana.security'));
    (0, _defineProperty2.default)(this, "loginDuration", void 0);
    (0, _defineProperty2.default)(this, "userProfileActivationDuration", void 0);
    (0, _defineProperty2.default)(this, "sessionCreationDuration", void 0);
    (0, _defineProperty2.default)(this, "logoutCounter", void 0);
    (0, _defineProperty2.default)(this, "privilegeRegistrationDuration", void 0);
    (0, _defineProperty2.default)(this, "recordLoginDuration", (duration, attributes) => {
      const transformedAttributes = this.transformAttributes(attributes);
      this.loginDuration.record(duration, transformedAttributes);
    });
    (0, _defineProperty2.default)(this, "recordUserProfileActivationDuration", (duration, attributes) => {
      const transformedAttributes = this.transformAttributes(attributes);
      this.userProfileActivationDuration.record(duration, transformedAttributes);
    });
    (0, _defineProperty2.default)(this, "recordSessionCreationDuration", (duration, attributes) => {
      const transformedAttributes = this.transformAttributes(attributes);
      this.sessionCreationDuration.record(duration, transformedAttributes);
    });
    (0, _defineProperty2.default)(this, "recordLogoutAttempt", attributes => {
      const transformedAttributes = this.transformAttributes(attributes);
      this.logoutCounter.add(1, transformedAttributes);
    });
    (0, _defineProperty2.default)(this, "recordPrivilegeRegistrationDuration", (duration, attributes) => {
      const transformedAttributes = this.transformAttributes(attributes);
      this.privilegeRegistrationDuration.record(duration, transformedAttributes);
    });
    this.loginDuration = this.meter.createHistogram('auth.login.duration', {
      description: 'Duration of login attempts',
      unit: 'ms',
      valueType: _api.ValueType.DOUBLE
    });
    this.userProfileActivationDuration = this.meter.createHistogram('auth.user_profile.activation.duration', {
      description: 'Duration of user profile activation attempts',
      unit: 'ms',
      valueType: _api.ValueType.DOUBLE
    });
    this.sessionCreationDuration = this.meter.createHistogram('auth.session.creation.duration', {
      description: 'Duration of session creation attempts',
      unit: 'ms',
      valueType: _api.ValueType.DOUBLE
    });
    this.logoutCounter = this.meter.createCounter('auth.logout.attempts', {
      description: 'Number of logout attempts',
      unit: '1',
      valueType: _api.ValueType.INT
    });
    this.privilegeRegistrationDuration = this.meter.createHistogram('auth.privilege.registration.duration', {
      description: 'Duration of privilege registration',
      unit: 'ms',
      valueType: _api.ValueType.DOUBLE
    });
  }
  transformAttributes(attributes) {
    const {
      application,
      providerType,
      outcome,
      deletedPrivileges,
      ...rest
    } = attributes;
    const transformed = {
      ...(application ? {
        application
      } : {}),
      ...(deletedPrivileges ? {
        'deleted.privileges': deletedPrivileges
      } : {}),
      ...(providerType ? {
        'auth.provider.type': providerType
      } : {}),
      ...(outcome ? {
        'auth.outcome': outcome
      } : {}),
      ...rest
    };
    return transformed;
  }
}
const securityTelemetry = exports.securityTelemetry = new SecurityTelemetry();