"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditRolePage = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _useAsync = _interopRequireDefault(require("react-use/lib/useAsync"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _reactKibanaContextTheme = require("@kbn/react-kibana-context-theme");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _public2 = require("@kbn/remote-clusters-plugin/public");
var _securityRoleManagementModel = require("@kbn/security-role-management-model");
var _common = require("@kbn/spaces-plugin/common");
var _delete_role_button = require("./delete_role_button");
var _privileges = require("./privileges");
var _reserved_role_badge = require("./reserved_role_badge");
var _validate_role = require("./validate_role");
var _model = require("../../../../common/model");
var _use_capabilities = require("../../../components/use_capabilities");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/security/public/management/roles/edit_role/edit_role_page.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function useRemoteClusters(http) {
  return (0, _useAsync.default)(() => http.get(_public2.REMOTE_CLUSTERS_PATH));
}
function useFeatureCheck(http, buildFlavor) {
  return (0, _useAsync.default)(async () => {
    if (buildFlavor !== 'serverless') {
      return http.get('/internal/security/_check_security_features');
    }
    return {
      value: true
    };
  }, [http, buildFlavor]);
}
function useRunAsUsers(userAPIClient, fatalErrors, buildFlavor) {
  const [userNames, setUserNames] = (0, _react.useState)(null);
  (0, _react.useEffect)(() => {
    if (buildFlavor !== 'serverless') {
      userAPIClient.getUsers().then(users => setUserNames(users.map(user => user.username)), err => fatalErrors.add(err));
    } else {
      setUserNames([]);
    }
  }, [fatalErrors, userAPIClient, buildFlavor]);
  return userNames;
}
function useIndexPatternsTitles(dataViews, fatalErrors, notifications) {
  const [indexPatternsTitles, setIndexPatternsTitles] = (0, _react.useState)(null);
  (0, _react.useEffect)(() => {
    dataViews.getTitles().catch(err => {
      var _err$response;
      // If user doesn't have access to the index patterns they still should be able to create new
      // or edit existing role.
      if (((_err$response = err.response) === null || _err$response === void 0 ? void 0 : _err$response.status) === 403) {
        notifications.toasts.addDanger({
          title: _i18n.i18n.translate('xpack.security.management.roles.noIndexPatternsPermission', {
            // Note: we are attempting to fetch data views (a Kibana construct), but we are using those to render a list of usable index
            // patterns (an Elasticsearch construct) for the user. This error message reflects what is shown on the UI.
            defaultMessage: 'You need permission to access the list of available index patterns.'
          })
        });
        return [];
      }
      fatalErrors.add(err);
    }).then(titles => setIndexPatternsTitles(titles.filter(Boolean)));
  }, [fatalErrors, dataViews, notifications]);
  return indexPatternsTitles;
}
function usePrivileges(privilegesAPIClient, fatalErrors) {
  const [privileges, setPrivileges] = (0, _react.useState)(null);
  (0, _react.useEffect)(() => {
    Promise.all([privilegesAPIClient.getAll({
      includeActions: true,
      respectLicenseLevel: false
    }), privilegesAPIClient.getBuiltIn()]).then(([kibanaPrivileges, builtInESPrivileges]) => setPrivileges([kibanaPrivileges, builtInESPrivileges]), err => fatalErrors.add(err));
  }, [privilegesAPIClient, fatalErrors]);
  return privileges;
}
function useRole(rolesAPIClient, fatalErrors, notifications, license, action, backToRoleList, roleName) {
  const [role, setRole] = (0, _react.useState)(null);
  (0, _react.useEffect)(() => {
    const rolePromise = roleName ? rolesAPIClient.getRole(roleName) : Promise.resolve({
      name: '',
      description: '',
      elasticsearch: {
        cluster: [],
        indices: [],
        run_as: []
      },
      kibana: [],
      _unrecognized_applications: []
    });
    rolePromise.then(fetchedRole => {
      if (action === 'clone' && (0, _model.isRoleReserved)(fetchedRole)) {
        backToRoleList();
        return;
      }
      const isEditingExistingRole = !!roleName && action === 'edit';
      if (!isEditingExistingRole && fetchedRole.elasticsearch.indices.length === 0) {
        const emptyOption = {
          names: [],
          privileges: []
        };
        const {
          allowRoleDocumentLevelSecurity,
          allowRoleFieldLevelSecurity
        } = license.getFeatures();
        if (allowRoleFieldLevelSecurity) {
          emptyOption.field_security = {
            grant: ['*'],
            except: []
          };
        }
        if (allowRoleDocumentLevelSecurity) {
          emptyOption.query = '';
        }
        fetchedRole.elasticsearch.indices.push(emptyOption);
      }
      setRole(action === 'clone' ? (0, _model.prepareRoleClone)(fetchedRole) : (0, _model.copyRole)(fetchedRole));
    }).catch(err => {
      var _err$response2;
      if (((_err$response2 = err.response) === null || _err$response2 === void 0 ? void 0 : _err$response2.status) === 404) {
        notifications.toasts.addDanger({
          title: _i18n.i18n.translate('xpack.security.management.roles.roleNotFound', {
            defaultMessage: 'No "{roleName}" role found.',
            values: {
              roleName
            }
          })
        });
        backToRoleList();
      } else {
        fatalErrors.add(err);
      }
    });
  }, [roleName, action, fatalErrors, rolesAPIClient, notifications, license, backToRoleList]);
  return [role, setRole];
}
function useSpaces(http, fatalErrors) {
  const [spaces, setSpaces] = (0, _react.useState)(null);
  (0, _react.useEffect)(() => {
    http.get('/api/spaces/space', {
      version: _common.API_VERSIONS.public.v1
    }).then(fetchedSpaces => setSpaces({
      enabled: true,
      list: fetchedSpaces
    }), err => {
      var _err$response3;
      // Spaces plugin can be disabled and hence this endpoint can be unavailable.
      if (((_err$response3 = err.response) === null || _err$response3 === void 0 ? void 0 : _err$response3.status) === 404) {
        setSpaces({
          enabled: false,
          list: []
        });
      } else {
        fatalErrors.add(err);
      }
    });
  }, [http, fatalErrors]);
  return spaces;
}
function useFeatures(getFeatures, fatalErrors) {
  const [features, setFeatures] = (0, _react.useState)(null);
  (0, _react.useEffect)(() => {
    getFeatures().catch(err => {
      var _err$response4;
      // Currently, the `/api/features` endpoint effectively requires the "Global All" kibana privilege (e.g., what
      // the `kibana_user` grants), because it returns information about all registered features (#35841). It's
      // possible that a user with `manage_security` will attempt to visit the role management page without the
      // correct Kibana privileges. If that's the case, then they receive a partial view of the role, and the UI does
      // not allow them to make changes to that role's kibana privileges. When this user visits the edit role page,
      // this API endpoint will throw a 403, which causes view to fail completely. So we instead attempt to detect the
      // 403 here, and respond in a way that still allows the UI to render itself.
      const unauthorizedForFeatures = ((_err$response4 = err.response) === null || _err$response4 === void 0 ? void 0 : _err$response4.status) === 403;
      if (unauthorizedForFeatures) {
        return [];
      }
      fatalErrors.add(err);
    }).then(retrievedFeatures => {
      var _retrievedFeatures$fi;
      setFeatures((_retrievedFeatures$fi = retrievedFeatures === null || retrievedFeatures === void 0 ? void 0 : retrievedFeatures.filter(feature => !feature.hidden)) !== null && _retrievedFeatures$fi !== void 0 ? _retrievedFeatures$fi : null);
    });
  }, [fatalErrors, getFeatures]);
  return features;
}
const EditRolePage = ({
  userAPIClient,
  dataViews,
  rolesAPIClient,
  indicesAPIClient,
  privilegesAPIClient,
  getFeatures,
  http,
  roleName,
  action,
  fatalErrors,
  license,
  docLinks,
  uiCapabilities,
  notifications,
  history,
  spacesApiUi,
  buildFlavor,
  cloudOrgUrl,
  ...startServices
}) => {
  const isDarkMode = (0, _reactKibanaContextTheme.useKibanaIsDarkMode)();
  if (!dataViews) {
    // The dataViews plugin is technically marked as an optional dependency because we don't need to pull it in for Anonymous pages (such
    // as the login page). That said, it _is_ required for this page to function correctly, so we throw an error here if it's not available.
    // We don't ever expect Kibana to work correctly if the dataViews plugin is not available (and we don't expect this to happen at all),
    // so this error edge case is an acceptable tradeoff.
    throw new Error('The dataViews plugin is required for this page, but it is not available');
  }
  const backToRoleList = (0, _react.useCallback)(() => history.push('/'), [history]);
  const hasReadOnlyPrivileges = !(0, _use_capabilities.useCapabilities)('roles').save;

  // We should keep the same mutable instance of Validator for every re-render since we'll
  // eventually enable validation after the first time user tries to save a role.
  const {
    current: validator
  } = (0, _react.useRef)(new _validate_role.RoleValidator({
    shouldValidate: false,
    buildFlavor
  }));
  const [formError, setFormError] = (0, _react.useState)(null);
  const [creatingRoleAlreadyExists, setCreatingRoleAlreadyExists] = (0, _react.useState)(false);
  const [previousName, setPreviousName] = (0, _react.useState)('');
  const runAsUsers = useRunAsUsers(userAPIClient, fatalErrors, buildFlavor);
  const indexPatternsTitles = useIndexPatternsTitles(dataViews, fatalErrors, notifications);
  const privileges = usePrivileges(privilegesAPIClient, fatalErrors);
  const spaces = useSpaces(http, fatalErrors);
  const features = useFeatures(getFeatures, fatalErrors);
  const featureCheckState = useFeatureCheck(http, buildFlavor);
  const remoteClustersState = useRemoteClusters(http);
  const [role, setRole] = useRole(rolesAPIClient, fatalErrors, notifications, license, action, backToRoleList, roleName);
  const isEditingExistingRole = !!roleName && action === 'edit';
  (0, _react.useEffect)(() => {
    if (hasReadOnlyPrivileges && !isEditingExistingRole) {
      backToRoleList();
    }
  }, [hasReadOnlyPrivileges, isEditingExistingRole]); // eslint-disable-line react-hooks/exhaustive-deps

  if (!role || !runAsUsers || !indexPatternsTitles || !privileges || !spaces || !features || !featureCheckState.value) {
    return null;
  }
  const isRoleReadOnly = hasReadOnlyPrivileges || (0, _model.isRoleReadOnly)(role);
  const isRoleReserved = (0, _model.isRoleReserved)(role);
  const isDeprecatedRole = (0, _model.isRoleDeprecated)(role);
  const [kibanaPrivileges, builtInESPrivileges] = privileges;
  const getFormTitle = () => {
    let titleText;
    const props = {
      tabIndex: 0
    };
    if (isRoleReserved || isRoleReadOnly) {
      titleText = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.management.editRole.viewingRoleTitle",
        defaultMessage: "Viewing role",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 411,
          columnNumber: 9
        }
      });
      props['aria-describedby'] = 'reservedRoleDescription';
    } else if (isEditingExistingRole) {
      titleText = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.management.editRole.editRoleTitle",
        defaultMessage: "Edit role",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 419,
          columnNumber: 9
        }
      });
    } else {
      titleText = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.management.editRole.createRoleTitle",
        defaultMessage: "Create role",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 426,
          columnNumber: 9
        }
      });
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "l",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 434,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("h1", (0, _extends2.default)({}, props, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 435,
        columnNumber: 9
      }
    }), titleText, " ", /*#__PURE__*/_react.default.createElement(_reserved_role_badge.ReservedRoleBadge, {
      role: role,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 436,
        columnNumber: 23
      }
    })));
  };
  const getActionButton = () => {
    if (isEditingExistingRole && !isRoleReadOnly) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 445,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_delete_role_button.DeleteRoleButton, {
        roleName: role.name,
        canDelete: true,
        onDelete: handleDeleteRole,
        buildFlavor: buildFlavor,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 446,
          columnNumber: 11
        }
      }));
    }
    return null;
  };
  const getRoleNameAndDescription = () => {
    var _role$description, _role$description2;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      hasShadow: false,
      hasBorder: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 461,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 462,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 463,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
      "data-test-subj": 'roleNameFormRow',
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.management.editRole.roleNameFormRowTitle",
        defaultMessage: "Role name",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 467,
          columnNumber: 17
        }
      }),
      helpText: !isEditingExistingRole ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.management.createRole.roleNameFormRowHelpText",
        defaultMessage: "Once the role is created you can no longer edit its name.",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 474,
          columnNumber: 19
        }
      }) : !isRoleReserved ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.management.editRole.roleNameFormRowHelpText",
        defaultMessage: "A role's name cannot be changed once it has been created.",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 479,
          columnNumber: 19
        }
      }) : undefined
    }, validator.validateRoleName(role), creatingRoleAlreadyExists ? {
      error: 'A role with this name already exists.',
      isInvalid: true
    } : {}, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 464,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      name: 'name',
      value: role.name || '',
      onChange: onNameChange,
      onBlur: onNameBlur,
      "data-test-subj": 'roleFormNameInput',
      disabled: isRoleReserved || isEditingExistingRole || isRoleReadOnly,
      isInvalid: creatingRoleAlreadyExists,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 490,
        columnNumber: 15
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 501,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      "data-test-subj": "roleDescriptionFormRow",
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.management.editRole.roleDescriptionFormRowTitle",
        defaultMessage: "Role description",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 505,
          columnNumber: 17
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 502,
        columnNumber: 13
      }
    }, isRoleReserved || isRoleReadOnly ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: role.description,
      display: "block",
      "data-test-subj": "roleFormDescriptionTooltip",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 512,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      name: "description",
      value: (_role$description = role.description) !== null && _role$description !== void 0 ? _role$description : '',
      "data-test-subj": "roleFormDescriptionInput",
      disabled: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 517,
        columnNumber: 19
      }
    })) : /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      name: "description",
      value: (_role$description2 = role.description) !== null && _role$description2 !== void 0 ? _role$description2 : '',
      onChange: onDescriptionChange,
      "data-test-subj": "roleFormDescriptionInput",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 525,
        columnNumber: 17
      }
    })))));
  };
  const onNameChange = e => setRole({
    ...role,
    name: e.target.value
  });
  const onNameBlur = _e => {
    if (!isEditingExistingRole && previousName !== role.name) {
      setPreviousName(role.name);
      doesRoleExist().then(roleExists => {
        setCreatingRoleAlreadyExists(roleExists);
      });
    }
  };
  const onDescriptionChange = e => setRole({
    ...role,
    description: e.target.value.trim().length ? e.target.value : undefined
  });
  const getElasticsearchPrivileges = () => {
    var _featureCheckState$va, _featureCheckState$va2;
    return /*#__PURE__*/_react.default.createElement(_privileges.ElasticsearchPrivileges, {
      role: role,
      editable: !isRoleReadOnly,
      indicesAPIClient: indicesAPIClient,
      onChange: onRoleChange,
      runAsUsers: runAsUsers,
      validator: validator,
      indexPatterns: indexPatternsTitles,
      remoteClusters: remoteClustersState.value,
      builtinESPrivileges: builtInESPrivileges,
      license: license,
      docLinks: docLinks,
      canUseRemoteIndices: buildFlavor === 'traditional' && ((_featureCheckState$va = featureCheckState.value) === null || _featureCheckState$va === void 0 ? void 0 : _featureCheckState$va.canUseRemoteIndices),
      canUseRemoteClusters: buildFlavor === 'traditional' && ((_featureCheckState$va2 = featureCheckState.value) === null || _featureCheckState$va2 === void 0 ? void 0 : _featureCheckState$va2.canUseRemoteClusters),
      isDarkMode: isDarkMode,
      buildFlavor: buildFlavor,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 562,
        columnNumber: 7
      }
    });
  };
  const onRoleChange = newRole => setRole(newRole);
  const getKibanaPrivileges = () => {
    return /*#__PURE__*/_react.default.createElement(_privileges.KibanaPrivilegesRegion, {
      kibanaPrivileges: new _securityRoleManagementModel.KibanaPrivileges(kibanaPrivileges, features),
      spaces: spaces.list,
      spacesEnabled: spaces.enabled,
      uiCapabilities: uiCapabilities,
      canCustomizeSubFeaturePrivileges: license.getFeatures().allowSubFeaturePrivileges,
      editable: !isRoleReadOnly,
      role: role,
      onChange: onRoleChange,
      validator: validator,
      spacesApiUi: spacesApiUi,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 590,
        columnNumber: 7
      }
    });
  };
  const getFormButtons = () => {
    if (isRoleReadOnly) {
      return getReturnToRoleListButton();
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      responsive: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 611,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 612,
        columnNumber: 9
      }
    }, getSaveButton()), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 613,
        columnNumber: 9
      }
    }, getCancelButton()), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 614,
        columnNumber: 9
      }
    }), getActionButton());
  };
  const getReturnToRoleListButton = () => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({}, (0, _public.reactRouterNavigate)(history, ''), {
      iconType: "arrowLeft",
      "data-test-subj": "roleFormReturnButton",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 622,
        columnNumber: 7
      }
    }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.editRole.returnToRoleListButtonLabel",
      defaultMessage: "Back to roles",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 627,
        columnNumber: 9
      }
    }));
  };
  const getSaveButton = () => {
    const saveText = isEditingExistingRole ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.editRole.updateRoleText",
      defaultMessage: "Update role",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 637,
        columnNumber: 7
      }
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.editRole.createRoleText",
      defaultMessage: "Create role",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 642,
        columnNumber: 7
      }
    });
    return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": `roleFormSaveButton`,
      fill: true,
      onClick: saveRole,
      disabled: isRoleReserved || creatingRoleAlreadyExists,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 649,
        columnNumber: 7
      }
    }, saveText);
  };
  const getCancelButton = () => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": `roleFormCancelButton`,
      onClick: backToRoleList,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 662,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.editRole.cancelButtonLabel",
      defaultMessage: "Cancel",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 663,
        columnNumber: 9
      }
    }));
  };
  const saveRole = async () => {
    validator.enableValidation();
    const result = validator.validateForSave(role);
    if (result.isInvalid) {
      setFormError(result);
    } else {
      setFormError(null);
      try {
        await rolesAPIClient.saveRole({
          role,
          createOnly: !isEditingExistingRole
        });
      } catch (error) {
        var _error$body, _error$body$message, _error$body2;
        if (!isEditingExistingRole && (error === null || error === void 0 ? void 0 : (_error$body = error.body) === null || _error$body === void 0 ? void 0 : _error$body.statusCode) === 409) {
          setCreatingRoleAlreadyExists(true);
          window.scroll({
            top: 0,
            behavior: 'smooth'
          });
          return;
        }
        notifications.toasts.addDanger((_error$body$message = error === null || error === void 0 ? void 0 : (_error$body2 = error.body) === null || _error$body2 === void 0 ? void 0 : _error$body2.message) !== null && _error$body$message !== void 0 ? _error$body$message : _i18n.i18n.translate('xpack.security.management.editRole.errorSavingRoleError', {
          defaultMessage: 'Error saving role'
        }));
        return;
      }
      if (buildFlavor === 'serverless') {
        notifications.toasts.addSuccess({
          title: _i18n.i18n.translate('xpack.security.management.editRole.customRoleSuccessfullySavedNotificationTitle', {
            defaultMessage: 'Custom role saved'
          }),
          text: (0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 705,
              columnNumber: 15
            }
          }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.security.management.editRole.customRoleSuccessfullySavedNotificationText",
            defaultMessage: "You can now assign this role to users of this project from your Organization page.",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 706,
              columnNumber: 17
            }
          })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
            justifyContent: "flexEnd",
            gutterSize: "s",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 711,
              columnNumber: 15
            }
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
            grow: false,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 712,
              columnNumber: 17
            }
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
            size: "s",
            href: cloudOrgUrl,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 713,
              columnNumber: 19
            }
          }, "Assign role")))), startServices)
        });
      } else {
        if (isEditingExistingRole) {
          notifications.toasts.addSuccess(_i18n.i18n.translate('xpack.security.management.editRole.roleSuccessfullyUpdatedNotificationMessage', {
            defaultMessage: 'Updated role'
          }));
        } else {
          notifications.toasts.addSuccess(_i18n.i18n.translate('xpack.security.management.editRole.roleSuccessfullyCreatedNotificationMessage', {
            defaultMessage: 'Created role'
          }));
        }
      }
      backToRoleList();
    }
  };
  const doesRoleExist = async () => {
    try {
      await rolesAPIClient.getRole(role.name);
      return true;
    } catch (error) {
      return false;
    }
  };
  const handleDeleteRole = async () => {
    try {
      await rolesAPIClient.deleteRole(role.name);
    } catch (error) {
      var _error$data$message, _error$data;
      notifications.toasts.addDanger((_error$data$message = error === null || error === void 0 ? void 0 : (_error$data = error.data) === null || _error$data === void 0 ? void 0 : _error$data.message) !== null && _error$data$message !== void 0 ? _error$data$message : _i18n.i18n.translate('xpack.security.management.editRole.errorDeletingRoleError', {
        defaultMessage: 'Error deleting role'
      }));
      return;
    }
    if (buildFlavor === 'serverless') {
      notifications.toasts.addDanger({
        title: _i18n.i18n.translate('xpack.security.management.roles.deleteRolesSuccessTitle', {
          defaultMessage: '{numberOfCustomRoles, plural, one {# custom role} other {# custom roles}} deleted',
          values: {
            numberOfCustomRoles: 1
          }
        }),
        text: (0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 775,
            columnNumber: 13
          }
        }, _i18n.i18n.translate('xpack.security.management.roles.deleteRolesSuccessMessage', {
          defaultMessage: `The deleted role will still appear listed on the user profile in Organization
                  Management and on the User Profile for those that don't have admin access.`
        })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          justifyContent: "flexEnd",
          gutterSize: "s",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 782,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 783,
            columnNumber: 15
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
          size: "s",
          href: cloudOrgUrl,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 784,
            columnNumber: 17
          }
        }, _i18n.i18n.translate('xpack.security.management.roles.manageRoleUsers', {
          defaultMessage: 'Manage Members'
        }))))), startServices)
      });
    } else {
      notifications.toasts.addSuccess(_i18n.i18n.translate('xpack.security.management.editRole.roleSuccessfullyDeletedNotificationMessage', {
        defaultMessage: 'Deleted role'
      }));
    }
    backToRoleList();
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "editRolePage",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 808,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, (0, _extends2.default)({}, formError, {
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 809,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 810,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 811,
      columnNumber: 11
    }
  }, getFormTitle(), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 813,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 814,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.management.editRole.setPrivilegesToKibanaSpacesDescription",
    defaultMessage: "Set privileges on your Elasticsearch data and control access to your Project spaces.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 815,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 821,
      columnNumber: 11
    }
  }, isRoleReserved && /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 823,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 824,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    id: "reservedRoleDescription",
    tabIndex: 0,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 825,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.management.editRole.modifyingReversedRolesDescription",
    defaultMessage: "Reserved roles are built-in and cannot be removed or modified.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 826,
      columnNumber: 21
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 835,
      columnNumber: 11
    }
  }, isDeprecatedRole && /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 837,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 838,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    title: (0, _model.getExtendedRoleDeprecationNotice)(role),
    color: "warning",
    iconType: "warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 839,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 848,
      columnNumber: 11
    }
  }, getRoleNameAndDescription()), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 849,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.editRole.dataLayerLabel",
      defaultMessage: "Data Layer",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 852,
        columnNumber: 17
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 850,
      columnNumber: 13
    }
  }, getElasticsearchPrivileges())), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 861,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center",
      responsive: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 864,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 865,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.editRole.appLayerLabel",
      defaultMessage: "Application layer",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 866,
        columnNumber: 21
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 871,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      type: "info",
      color: "subdued",
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.management.editRole.appLayerTooltipText",
        defaultMessage: "Feature access is granted on a per space basis for all features. Feature visibility is set on the space. Both must be enabled for this role to use a feature",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 876,
          columnNumber: 25
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 872,
        columnNumber: 21
      }
    }))),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 862,
      columnNumber: 13
    }
  }, getKibanaPrivileges())), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 889,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 890,
      columnNumber: 13
    }
  }, getFormButtons())))));
};
exports.EditRolePage = EditRolePage;