"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Header = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _use_search_playground_feature_flag = require("../hooks/use_search_playground_feature_flag");
var _types = require("../types");
var _playground_header_docs = require("./playground_header_docs");
var _save_new_playground_button = require("./save_new_playground_button");
var _toolbar = require("./toolbar");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_playground/public/components/header.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const Header = ({
  pageMode,
  viewMode,
  onModeChange,
  showDocs = false,
  isActionsDisabled = false,
  onSelectPageModeChange
}) => {
  const isSearchModeEnabled = (0, _use_search_playground_feature_flag.useSearchPlaygroundFeatureFlag)();
  const options = [{
    id: _types.PlaygroundViewMode.preview,
    label: pageMode === _types.PlaygroundPageMode.chat ? _i18n.i18n.translate('xpack.searchPlayground.header.view.chat', {
      defaultMessage: 'Chat'
    }) : _i18n.i18n.translate('xpack.searchPlayground.header.view.preview', {
      defaultMessage: 'Preview'
    }),
    'data-test-subj': 'chatMode'
  }, {
    id: _types.PlaygroundViewMode.query,
    label: _i18n.i18n.translate('xpack.searchPlayground.header.view.query', {
      defaultMessage: 'Query'
    }),
    'data-test-subj': 'queryMode'
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.Header, {
    css: ({
      euiTheme
    }) => ({
      '.euiPageHeaderContent > .euiFlexGroup': {
        flexWrap: 'wrap'
      },
      backgroundColor: euiTheme.colors.emptyShade
    }),
    "data-test-subj": "chat-playground-home-page",
    paddingSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeaderSection, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    css: {
      whiteSpace: 'nowrap'
    },
    "data-test-subj": "chat-playground-home-page-title",
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.unsaved.pageTitle",
    defaultMessage: "Unsaved playground",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 15
    }
  }))), isSearchModeEnabled && /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    "data-test-subj": "page-mode-select",
    options: [{
      value: _types.PlaygroundPageMode.Chat,
      text: 'Chat'
    }, {
      value: _types.PlaygroundPageMode.Search,
      text: 'Search'
    }],
    value: pageMode,
    "aria-label": _i18n.i18n.translate('xpack.searchPlayground.header.pageModeSelectAriaLabel', {
      defaultMessage: 'Page mode'
    }),
    onChange: e => onSelectPageModeChange(e.target.value),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeaderSection, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    legend: "viewMode",
    options: options,
    idSelected: viewMode,
    onChange: id => onModeChange(id),
    buttonSize: "compressed",
    isDisabled: isActionsDisabled,
    "data-test-subj": "viewModeSelector",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeaderSection, {
    css: ({
      euiTheme
    }) => ({
      paddingRight: euiTheme.size.s
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 9
    }
  }, showDocs && /*#__PURE__*/_react.default.createElement(_playground_header_docs.PlaygroundHeaderDocs, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 24
    }
  }), /*#__PURE__*/_react.default.createElement(_toolbar.Toolbar, {
    selectedPageMode: pageMode,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_save_new_playground_button.SaveNewPlaygroundButton, {
    disabled: isActionsDisabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 11
    }
  }))));
};
exports.Header = Header;