"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldErrorCallout = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_playground/public/components/field_error_callout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function errorMessageFromType(type) {
  switch (type) {
    case 'required':
      return _i18n.i18n.translate('xpack.searchPlayground.formErrors.required', {
        defaultMessage: 'Required'
      });
    default:
      return _i18n.i18n.translate('xpack.searchPlayground.formErrors.fallbackErrorMessage', {
        defaultMessage: 'Invalid input'
      });
  }
}
const FieldErrorCallout = ({
  error
}) => {
  var _error$message;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "danger",
    iconType: "error",
    title: (_error$message = error.message) !== null && _error$message !== void 0 ? _error$message : errorMessageFromType(error.type),
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 5
    }
  });
};
exports.FieldErrorCallout = FieldErrorCallout;