"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddDataButton = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _deeplinksSearch = require("@kbn/deeplinks-search");
var _use_kibana = require("../../hooks/use_kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_getting_started/public/components/header/add_data_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AddDataButton = () => {
  const {
    services: {
      application
    }
  } = (0, _use_kibana.useKibana)();
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const onButtonClick = () => {
    setIsPopoverOpen(!isPopoverOpen);
  };
  const closePopover = () => {
    setIsPopoverOpen(false);
  };
  const items = [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "upload",
    icon: "exportAction",
    "data-test-subj": "gettingStartedUploadMenuItem",
    onClick: () => {
      closePopover();
      application.navigateToApp('home', {
        path: '#/tutorial_directory/fileDataViz'
      });
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 5
    }
  }, _i18n.i18n.translate('xpack.search.gettingStarted.addDataButton.uploadFile', {
    defaultMessage: 'Upload a file'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "sample",
    icon: "folderOpen",
    "data-test-subj": "gettingStartedSampleDataMenuItem",
    onClick: () => {
      closePopover();
      application.navigateToApp('home', {
        path: '#/tutorial_directory/sampleData'
      });
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 5
    }
  }, _i18n.i18n.translate('xpack.search.gettingStarted.addDataButton.browseSampleData', {
    defaultMessage: 'Browse sample datasets'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "empty",
    icon: "indexOpen",
    "data-test-subj": "gettingStartedCreateIndexMenuItem",
    onClick: () => {
      closePopover();
      application.navigateToApp(_deeplinksSearch.SEARCH_INDICES, {
        path: 'create'
      });
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 5
    }
  }, _i18n.i18n.translate('xpack.search.gettingStarted.addDataButton.createEmptyIndex', {
    defaultMessage: 'Create an empty index'
  }))];
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "primary",
    fill: true,
    iconType: "arrowDown",
    iconSide: "right",
    onClick: onButtonClick,
    "data-test-subj": "gettingStartedAddDataButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 5
    }
  }, _i18n.i18n.translate('xpack.search.gettingStarted.addDataButton.label', {
    defaultMessage: 'Add data'
  }));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: button,
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none",
    anchorPosition: "downLeft",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    items: items,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 7
    }
  }));
};
exports.AddDataButton = AddDataButton;