"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SyncJobCallouts = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _duration_to_text = require("../../utils/duration_to_text");
var _formatted_date_time = require("../../utils/formatted_date_time");
var _ = require("../..");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/src/platform/packages/shared/kbn-search-connectors/components/sync_jobs/sync_callouts.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const SyncJobCallouts = ({
  syncJob
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !!syncJob.completed_at && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    color: "success",
    iconType: "check",
    title: _i18n.i18n.translate('searchConnectors.syncJobs.flyout.completedTitle', {
      defaultMessage: 'Sync complete'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "searchConnectors.syncJobs.flyout.completedDescription",
    defaultMessage: "Completed at {date}",
    values: {
      date: /*#__PURE__*/_react.default.createElement(_formatted_date_time.FormattedDateTime, {
        date: new Date(syncJob.completed_at),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 44,
          columnNumber: 23
        }
      })
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 13
    }
  }))), syncJob.status === _.SyncStatus.ERROR && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    color: "danger",
    iconType: "cross",
    title: _i18n.i18n.translate('searchConnectors.syncJobs.flyout.failureTitle', {
      defaultMessage: 'Sync failure'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('searchConnectors.syncJobs.flyout.failureDescription', {
    defaultMessage: 'Sync failure: {error}.',
    values: {
      error: syncJob.error
    }
  }))), syncJob.status === _.SyncStatus.CANCELED && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    color: "danger",
    iconType: "cross",
    title: _i18n.i18n.translate('searchConnectors.syncJobs.flyout.canceledTitle', {
      defaultMessage: 'Sync canceled'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 11
    }
  }, !!syncJob.canceled_at && /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "searchConnectors.syncJobs.flyout.canceledDescription",
    defaultMessage: "Sync canceled at {date}",
    values: {
      date: /*#__PURE__*/_react.default.createElement(_formatted_date_time.FormattedDateTime, {
        date: new Date(syncJob.canceled_at),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 84,
          columnNumber: 25
        }
      })
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 15
    }
  }))), syncJob.status === _.SyncStatus.IN_PROGRESS && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    color: "warning",
    iconType: "clock",
    title: _i18n.i18n.translate('searchConnectors.syncJobs.flyout.inProgressTitle', {
      defaultMessage: 'In progress'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('searchConnectors.syncJobs.flyout.inProgressDescription', {
    defaultMessage: 'Sync has been running for {duration}.',
    values: {
      duration: (0, _duration_to_text.durationToText)((0, _duration_to_text.getSyncJobDuration)(syncJob))
    }
  }))), !!syncJob.started_at && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    color: "primary",
    iconType: "info",
    title: syncJob.trigger_method === _.TriggerMethod.ON_DEMAND ? _i18n.i18n.translate('searchConnectors.syncJobs.flyout.syncStartedManually', {
      defaultMessage: 'Sync started manually'
    }) : _i18n.i18n.translate('searchConnectors.syncJobs.flyout.syncStartedScheduled', {
      defaultMessage: 'Sync started by schedule'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "searchConnectors.syncJobs.flyout.startedAtDescription",
    defaultMessage: "Started at {date}",
    values: {
      date: /*#__PURE__*/_react.default.createElement(_formatted_date_time.FormattedDateTime, {
        date: new Date(syncJob.started_at),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 130,
          columnNumber: 23
        }
      })
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 13
    }
  }))));
};
exports.SyncJobCallouts = SyncJobCallouts;