"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorContentScheduling = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _connectors = require("../../types/connectors");
var _platinum_license_popover = require("../configuration/platinum_license_popover");
var _connector_cron_editor = require("./connector_cron_editor");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/src/platform/packages/shared/kbn-search-connectors/components/scheduling/full_content.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getAccordionTitle = type => {
  switch (type) {
    case _connectors.SyncJobType.FULL:
      {
        return _i18n.i18n.translate('searchConnectors.content.indices.connectorScheduling.accordion.fullSync.title', {
          defaultMessage: 'Full content sync'
        });
      }
    case _connectors.SyncJobType.INCREMENTAL:
      {
        return _i18n.i18n.translate('searchConnectors.content.indices.connectorScheduling.accordion.incrementalSync.title', {
          defaultMessage: 'Incremental content sync'
        });
      }
    case _connectors.SyncJobType.ACCESS_CONTROL:
      {
        return _i18n.i18n.translate('searchConnectors.content.indices.connectorScheduling.accordion.accessControlSync.title', {
          defaultMessage: 'Access Control Sync'
        });
      }
  }
};
const getDescriptionText = type => {
  switch (type) {
    case _connectors.SyncJobType.FULL:
      {
        return _i18n.i18n.translate('searchConnectors.content.indices.connectorScheduling.accordion.fullSync.description', {
          defaultMessage: 'Synchronize all data from your data source.'
        });
      }
    case _connectors.SyncJobType.INCREMENTAL:
      {
        return _i18n.i18n.translate('searchConnectors.content.indices.connectorScheduling.accordion.incrementalSync.description', {
          defaultMessage: 'A lightweight sync job that only fetches updated content from your data source.'
        });
      }
    case _connectors.SyncJobType.ACCESS_CONTROL:
      {
        return _i18n.i18n.translate('searchConnectors.content.indices.connectorScheduling.accordion.accessControlSync.description', {
          defaultMessage: 'Schedule access control syncs to keep permissions mappings up to date.'
        });
      }
  }
};
const EnableSwitch = ({
  disabled,
  checked,
  onChange
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
  disabled: disabled,
  checked: checked,
  label: _i18n.i18n.translate('searchConnectors.content.indices.connectorScheduling.switch.label', {
    defaultMessage: 'Enabled'
  }),
  onChange: onChange,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 93,
    columnNumber: 3
  }
});
const ConnectorContentScheduling = ({
  connector,
  dataTelemetryIdPrefix,
  setHasSyncTypeChanges,
  hasPlatinumLicense = false,
  hasSyncTypeChanges,
  isDisabled,
  type,
  updateConnectorStatus,
  updateScheduling
}) => {
  var _connector$configurat;
  const schedulingInput = connector.scheduling;
  const [scheduling, setScheduling] = (0, _react.useState)(schedulingInput);
  const [isAccordionOpen, setIsAccordionOpen] = (0, _react.useState)(scheduling[type].enabled ? 'open' : 'closed');
  const [isPlatinumPopoverOpen, setIsPlatinumPopoverOpen] = (0, _react.useState)(false);
  const isGated = !hasPlatinumLicense && type === _connectors.SyncJobType.ACCESS_CONTROL;
  const isDocumentLevelSecurityDisabled = !((_connector$configurat = connector.configuration.use_document_level_security) !== null && _connector$configurat !== void 0 && _connector$configurat.value);
  const isEnableSwitchDisabled = type === _connectors.SyncJobType.ACCESS_CONTROL && (!hasPlatinumLicense || isDocumentLevelSecurityDisabled) || Boolean(isDisabled);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    paddingSize: "m",
    id: `${type}-content-sync-schedule`,
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 137,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 138,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 139,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement("h5", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 140,
        columnNumber: 19
      }
    }, getAccordionTitle(type)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 143,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 144,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 145,
        columnNumber: 19
      }
    }, getDescriptionText(type))))),
    forceState: isAccordionOpen,
    onToggle: isOpen => {
      setIsAccordionOpen(isOpen ? 'open' : 'closed');
    },
    extraAction: isGated ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      responsive: false,
      gutterSize: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 156,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 157,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_platinum_license_popover.PlatinumLicensePopover, {
      isPopoverOpen: isPlatinumPopoverOpen,
      closePopover: () => setIsPlatinumPopoverOpen(!isPlatinumPopoverOpen),
      button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        "aria-label": _i18n.i18n.translate('searchConnectors.selectConnector.openPopoverLabel', {
          defaultMessage: 'Open licensing popover'
        }),
        iconType: "question",
        onClick: () => setIsPlatinumPopoverOpen(!isPlatinumPopoverOpen),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 162,
          columnNumber: 23
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 158,
        columnNumber: 19
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 175,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(EnableSwitch, {
      disabled: isEnableSwitchDisabled,
      checked: scheduling[type].enabled,
      onChange: e => {
        if (e.target.checked) {
          setIsAccordionOpen('open');
        }
        setScheduling({
          ...scheduling,
          ...{
            [type]: {
              enabled: e.target.checked,
              interval: scheduling[type].interval
            }
          }
        });
        setHasSyncTypeChanges(true);
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 176,
        columnNumber: 19
      }
    }))) : /*#__PURE__*/_react.default.createElement(EnableSwitch, {
      disabled: isEnableSwitchDisabled,
      checked: scheduling[type].enabled,
      onChange: e => {
        if (e.target.checked) {
          setIsAccordionOpen('open');
        }
        setScheduling({
          ...scheduling,
          ...{
            [type]: {
              enabled: e.target.checked,
              interval: scheduling[type].interval
            }
          }
        });
        setHasSyncTypeChanges(true);
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 198,
        columnNumber: 15
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 220,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 221,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_connector_cron_editor.ConnectorCronEditor, {
    hasSyncTypeChanges: hasSyncTypeChanges,
    setHasSyncTypeChanges: setHasSyncTypeChanges,
    disabled: isGated || Boolean(isDisabled),
    scheduling: scheduling[type],
    onReset: () => {
      setScheduling({
        ...schedulingInput
      });
    },
    onSave: interval => {
      const updatedScheduling = {
        ...connector.scheduling,
        [type]: {
          ...scheduling[type],
          interval
        }
      };
      updateScheduling(updatedScheduling);
      setHasSyncTypeChanges(false);
    },
    status: updateConnectorStatus,
    dataTelemetryIdPrefix: dataTelemetryIdPrefix,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 222,
      columnNumber: 15
    }
  }))))));
};
exports.ConnectorContentScheduling = ConnectorContentScheduling;