"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChromiumArchivePaths = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _path = _interopRequireDefault(require("path"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
var BaseUrl = /*#__PURE__*/function (BaseUrl) {
  BaseUrl["custom"] = "https://storage.googleapis.com/headless_shell";
  BaseUrl["chromeForTesting"] = "https://storage.googleapis.com/chrome-for-testing-public";
  return BaseUrl;
}(BaseUrl || {});
function isChromeForTestingPackage(p) {
  return p.location === 'chromeForTesting';
}
class ChromiumArchivePaths {
  constructor() {
    (0, _defineProperty2.default)(this, "packages", [{
      platform: 'darwin',
      architecture: 'x64',
      archiveFilename: 'chrome-headless-shell-mac-x64.zip',
      archiveChecksum: '1dd9cdc5da669ab1b82757cc456122377bc42c991344b3628a4cb19e066484ba',
      binaryChecksum: 'f2d30ef297dfc857042c280db6ac5cb1c6982a7ff33e93b8e1bef210a7eac2a8',
      binaryRelativePath: 'chrome-headless-shell-mac-x64/chrome-headless-shell',
      version: '141.0.7390.76',
      location: 'chromeForTesting',
      archivePath: 'mac-x64',
      isPreInstalled: false
    }, {
      platform: 'darwin',
      architecture: 'arm64',
      archiveFilename: 'chrome-headless-shell-mac-arm64.zip',
      archiveChecksum: 'b45cdf65c85338a5a64da4ab8a33bdc4c8b7e5f9b322fbdeb858ffe27e835bd3',
      binaryChecksum: 'a486f30ab421a27b63be310cb81dd930654574aba444fe528686cf460a8e85ee',
      binaryRelativePath: 'chrome-headless-shell-mac-arm64/chrome-headless-shell',
      version: '141.0.7390.76',
      location: 'chromeForTesting',
      archivePath: 'mac-arm64',
      isPreInstalled: false
    }, {
      platform: 'linux',
      architecture: 'x64',
      archiveFilename: 'chromium-d6fcfbb-locales-linux_x64.zip',
      archiveChecksum: '45174942ed4c14fe2c1c0ff92d6882020068346a0bf1895fd125d21ca4a5e94a',
      binaryChecksum: '9079fdac5cad7a495e33b12e77697f5cfc4775022b45a4dad6cdcf5f4c09d705',
      binaryRelativePath: 'headless_shell-linux_x64/headless_shell',
      location: 'custom',
      isPreInstalled: true
    }, {
      platform: 'linux',
      architecture: 'arm64',
      archiveFilename: 'chromium-d6fcfbb-locales-linux_arm64.zip',
      archiveChecksum: '97bcfa710fa37e200f5b945c1f12faf35520eb9b25e76d8f53f996455b593320',
      binaryChecksum: '8186895cc10c1bbaf576b183175b26cf8ef6688b2c88ccc6cfb75250fd381bcf',
      binaryRelativePath: 'headless_shell-linux_arm64/headless_shell',
      location: 'custom',
      isPreInstalled: true
    }, {
      platform: 'win32',
      architecture: 'x64',
      archiveFilename: 'chrome-headless-shell-win64.zip',
      archiveChecksum: '727bf476bad55e6caaa491420e843d41b70ff69140bea4026e913034980f804e',
      binaryChecksum: 'f5a30ff0b6e1cbd99d05337817d06558dc20213ab903bdb7263016b30a476feb',
      binaryRelativePath: _path.default.join('chrome-headless-shell-win64', 'chrome-headless-shell.exe'),
      version: '141.0.7390.76',
      location: 'chromeForTesting',
      archivePath: 'win64',
      isPreInstalled: true
    }]);
    // zip files get downloaded to a .chromium directory in the kibana root
    (0, _defineProperty2.default)(this, "archivesPath", _path.default.resolve(__dirname, '../../../../../../.chromium'));
  }
  find(platform, architecture, packages = this.packages) {
    return packages.find(p => p.platform === platform && p.architecture === architecture);
  }
  resolvePath(p) {
    // adding architecture to the path allows it to download two binaries that have the same name, but are different architecture
    return _path.default.resolve(this.archivesPath, p.architecture, p.archiveFilename);
  }
  getAllArchiveFilenames() {
    return this.packages.map(p => this.resolvePath(p));
  }
  getDownloadUrl(p) {
    if (isChromeForTestingPackage(p)) {
      const {
        chromeForTesting
      } = BaseUrl;
      const {
        archivePath,
        version,
        archiveFilename
      } = p;
      // returned string matches download value found at the following endpoint;
      // https://googlechromelabs.github.io/chrome-for-testing/known-good-versions-with-downloads.json
      return `${chromeForTesting}/${version}/${archivePath}/${archiveFilename}`;
    }
    return BaseUrl.custom + '/' + p.archiveFilename; // revision is not used for URL if package is a custom build
  }
  getBinaryPath(p, chromiumPath) {
    return _path.default.join(chromiumPath, p.binaryRelativePath);
  }
}
exports.ChromiumArchivePaths = ChromiumArchivePaths;