"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.download = void 0;
var _fs = require("fs");
var _promises = require("fs/promises");
var _promises2 = require("stream/promises");
var _path = _interopRequireDefault(require("path"));
var _nodeFetch = _interopRequireDefault(require("node-fetch"));
var _validators = require("./validators");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const download = async (fileUrl, filePath, expectedMimeType, abortController) => {
  (0, _validators.validatePath)(filePath);
  const dirPath = _path.default.dirname(filePath);
  await (0, _promises.mkdir)(dirPath, {
    recursive: true
  });
  const writeStream = (0, _fs.createWriteStream)(filePath);
  let res;
  try {
    res = await (0, _nodeFetch.default)(fileUrl, {
      signal: abortController === null || abortController === void 0 ? void 0 : abortController.signal
    });
  } catch (err) {
    if (err.name === 'AbortError') {
      writeStream.destroy();
      throw new Error('Download aborted');
    }
    throw err;
  }
  if (!res.ok) {
    throw new Error(`Failed to download file: ${res.status} ${res.statusText}`);
  }
  (0, _validators.validateMimeType)(res.headers.get('content-type'), expectedMimeType);
  if (!res.body) {
    throw new Error('Response body is null');
  }
  try {
    await (0, _promises2.pipeline)(res.body, writeStream);
  } catch (err) {
    if (err.name === 'AbortError') {
      writeStream.destroy();
      throw new Error('Download aborted during streaming');
    }
    throw err;
  }
  await (0, _validators.validateFileSignature)(filePath, expectedMimeType);
};
exports.download = download;