"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.timeSeriesMetric = exports.getAlertFieldsResponseSchema = exports.getAlertFieldsRequestSchema = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const timeSeriesMetric = exports.timeSeriesMetric = {
  GAUGE: 'gauge',
  COUNTER: 'counter',
  SUMMARY: 'summary',
  HISTOGRAM: 'histogram',
  POSITION: 'position'
};
const getAlertFieldsRequestSchema = exports.getAlertFieldsRequestSchema = _configSchema.schema.object({
  rule_type_ids: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.arrayOf(_configSchema.schema.string({
    meta: {
      description: 'Array of rule type ids.'
    }
  })), _configSchema.schema.string({
    meta: {
      description: 'Single rule type id.'
    }
  })], {
    defaultValue: []
  }))
});
const getAlertFieldsResponseSchema = exports.getAlertFieldsResponseSchema = _configSchema.schema.object({
  fields: _configSchema.schema.arrayOf(_configSchema.schema.object({
    aggregatable: _configSchema.schema.boolean(),
    name: _configSchema.schema.string(),
    readFromDocValues: _configSchema.schema.boolean(),
    searchable: _configSchema.schema.boolean(),
    type: _configSchema.schema.string(),
    esTypes: _configSchema.schema.arrayOf(_configSchema.schema.string()),
    subType: _configSchema.schema.maybe(_configSchema.schema.object({
      multi: _configSchema.schema.maybe(_configSchema.schema.object({
        parent: _configSchema.schema.string()
      })),
      nested: _configSchema.schema.maybe(_configSchema.schema.object({
        path: _configSchema.schema.string()
      }))
    })),
    metadata_field: _configSchema.schema.maybe(_configSchema.schema.boolean()),
    fixedInterval: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
    timeZone: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
    timeSeriesMetric: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal(timeSeriesMetric.GAUGE), _configSchema.schema.literal(timeSeriesMetric.COUNTER), _configSchema.schema.literal(timeSeriesMetric.SUMMARY), _configSchema.schema.literal(timeSeriesMetric.HISTOGRAM), _configSchema.schema.literal(timeSeriesMetric.POSITION)])),
    timeSeriesDimension: _configSchema.schema.maybe(_configSchema.schema.boolean()),
    defaultFormatter: _configSchema.schema.maybe(_configSchema.schema.string())
  }))
});