"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateAnomalyDetectionCustomFilter = validateAnomalyDetectionCustomFilter;
var _mlAnomalyUtils = require("@kbn/ml-anomaly-utils");
var _utils = require("../common/utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Validates the kqlQueryString for anomaly detection rules.
 * Validates both KQL syntax and checks against disallowed fields.
 */
function validateAnomalyDetectionCustomFilter(kqlQueryString, resultType) {
  if (!kqlQueryString) {
    return undefined;
  }
  const syntaxError = (0, _utils.validateKQLStringFilter)(kqlQueryString);
  if (syntaxError) {
    return syntaxError;
  }
  return (0, _mlAnomalyUtils.validateCustomFilterFields)(kqlQueryString, resultType);
}