"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformBulkDeleteResponse = transformBulkDeleteResponse;
exports.transformListResponse = transformListResponse;
exports.transformSingleResponse = transformSingleResponse;
var _rrule2 = require("@kbn/rrule");
var _spacesUtils = require("@kbn/spaces-utils");
var _result_type = require("@kbn/task-manager-plugin/server/lib/result_type");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SCHEDULED_REPORT_ID_FIELD = 'scheduled_report_id';
const CREATED_AT_FIELD = 'created_at';
function transformSingleResponse(logger, so, lastResponse, nextRunResponse) {
  var _lastResponse$hits$hi, _lastRunForId$_source, _so$namespaces$, _so$namespaces;
  const id = so.id;
  const lastRunForId = ((_lastResponse$hits$hi = lastResponse === null || lastResponse === void 0 ? void 0 : lastResponse.hits.hits) !== null && _lastResponse$hits$hi !== void 0 ? _lastResponse$hits$hi : []).find(hit => {
    var _hit$fields, _hit$fields$SCHEDULED;
    return ((_hit$fields = hit.fields) === null || _hit$fields === void 0 ? void 0 : (_hit$fields$SCHEDULED = _hit$fields[SCHEDULED_REPORT_ID_FIELD]) === null || _hit$fields$SCHEDULED === void 0 ? void 0 : _hit$fields$SCHEDULED[0]) === id;
  });
  const nextRunForId = (nextRunResponse !== null && nextRunResponse !== void 0 ? nextRunResponse : []).find(taskOrError => (0, _result_type.isOk)(taskOrError) && taskOrError.value.id === id);
  let nextRun;
  if (!nextRunForId) {
    var _rrule$after;
    // try to calculate dynamically if we were not able to get from the task
    const schedule = so.attributes.schedule;

    // get start date
    let dtstart = new Date();
    const rruleStart = schedule.rrule.dtstart;
    if (rruleStart) {
      try {
        // if start date is provided and in the future, use it, otherwise use current time
        const startDateValue = new Date(rruleStart).valueOf();
        const now = Date.now();
        if (startDateValue > now) {
          dtstart = new Date(startDateValue + 60000); // add 1 minute to ensure it's in the future
        }
      } catch (e) {
        logger.debug(`Failed to parse rrule.dtstart for scheduled report next run calculation - default to now ${id}: ${e.message}`);
      }
    }
    const _rrule = new _rrule2.RRule({
      ...schedule.rrule,
      dtstart
    });
    nextRun = (_rrule$after = _rrule.after(new Date())) === null || _rrule$after === void 0 ? void 0 : _rrule$after.toISOString();
  } else {
    nextRun = (0, _result_type.isOk)(nextRunForId) ? nextRunForId.value.runAt.toISOString() : undefined;
  }
  let payload;
  try {
    payload = JSON.parse(so.attributes.payload);
  } catch (e) {
    logger.warn(`Failed to parse payload for scheduled report ${id}: ${e.message}`);
  }
  return {
    id,
    created_at: so.attributes.createdAt,
    created_by: so.attributes.createdBy,
    enabled: so.attributes.enabled,
    jobtype: so.attributes.jobType,
    last_run: lastRunForId === null || lastRunForId === void 0 ? void 0 : (_lastRunForId$_source = lastRunForId._source) === null || _lastRunForId$_source === void 0 ? void 0 : _lastRunForId$_source[CREATED_AT_FIELD],
    next_run: nextRun,
    notification: so.attributes.notification,
    payload,
    schedule: so.attributes.schedule,
    space_id: (_so$namespaces$ = (_so$namespaces = so.namespaces) === null || _so$namespaces === void 0 ? void 0 : _so$namespaces[0]) !== null && _so$namespaces$ !== void 0 ? _so$namespaces$ : _spacesUtils.DEFAULT_SPACE_ID,
    title: so.attributes.title
  };
}
function transformListResponse(logger, result, lastResponse, nextRunResponse) {
  return {
    page: result.page,
    per_page: result.per_page,
    total: result.total,
    data: result.saved_objects.map(so => transformSingleResponse(logger, so, lastResponse, nextRunResponse))
  };
}
function transformBulkDeleteResponse({
  deletedSchedulesIds,
  errors
}) {
  return {
    scheduled_report_ids: deletedSchedulesIds,
    errors,
    total: deletedSchedulesIds.length + errors.length
  };
}