"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditScheduledReportFlyout = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _convert_to_rrule = require("@kbn/response-ops-recurring-schedule-form/utils/convert_to_rrule");
var _reportingPublic = require("@kbn/reporting-public");
var _coreMountUtilsBrowserInternal = require("@kbn/core-mount-utils-browser-internal");
var _scheduled_report_form = require("./scheduled_report_form");
var _use_update_schedule_report = require("../hooks/use_update_schedule_report");
var i18n = _interopRequireWildcard(require("../translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/reporting/public/management/components/edit_scheduled_report_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EditScheduledReportFlyout = ({
  scheduledReport,
  availableReportTypes,
  onClose
}) => {
  const {
    http,
    notifications: {
      toasts
    }
  } = (0, _reportingPublic.useKibana)().services;
  const {
    mutateAsync: updateScheduleReport,
    isLoading: isSubmitLoading
  } = (0, _use_update_schedule_report.useUpdateScheduleReport)({
    http
  });
  const onSubmit = async formData => {
    try {
      const {
        title,
        startDate,
        timezone,
        recurringSchedule
      } = formData;
      const rrule = (0, _convert_to_rrule.convertToRRule)({
        startDate,
        timezone,
        recurringSchedule,
        includeTime: true
      });
      await updateScheduleReport({
        reportId: scheduledReport.id,
        title,
        schedule: {
          rrule: rrule
        }
      });
      toasts.addSuccess({
        title: i18n.SCHEDULED_REPORT_UPDATE_SUCCESS_TOAST_TITLE,
        text: (0, _coreMountUtilsBrowserInternal.mountReactNode)(/*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, i18n.SCHEDULED_REPORT_UPDATE_SUCCESS_TOAST_MESSAGE))
      });
    } catch (error) {
      toasts.addError(error, {
        title: i18n.SCHEDULED_REPORT_FORM_FAILURE_TOAST_TITLE,
        toastMessage: i18n.SCHEDULED_REPORT_FORM_FAILURE_TOAST_MESSAGE
      });
      // Forward error to signal whether to close the flyout or not
      throw error;
    }
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    size: "m",
    maxWidth: 500,
    paddingSize: "l",
    ownFocus: true,
    onClose: onClose,
    "data-test-subj": "editScheduledReportFlyout",
    "aria-label": "editScheduledReportFlyout",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_scheduled_report_form.ScheduledReportForm, {
    scheduledReport: scheduledReport,
    availableReportTypes: availableReportTypes,
    onClose: onClose,
    onSubmitForm: onSubmit,
    isSubmitLoading: isSubmitLoading,
    editMode: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 7
    }
  }));
};
exports.EditScheduledReportFlyout = EditScheduledReportFlyout;