"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.areCloudResourcesSetup = areCloudResourcesSetup;
exports.createDefaultCloudSetupState = createDefaultCloudSetupState;
var _setup = require("./setup");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createDefaultCloudSetupState() {
  const defaultSetupState = (0, _setup.createDefaultSetupState)();
  return {
    cloud: {
      available: false,
      required: true
    },
    policies: {
      collector: {
        installed: false
      },
      symbolizer: {
        installed: false
      },
      apm: {
        profilingEnabled: false
      }
    },
    ...defaultSetupState
  };
}
function areCloudResourcesSetup(state) {
  return (0, _setup.areResourcesSetup)(state) && state.policies.collector.installed && state.policies.symbolizer.installed && !state.policies.apm.profilingEnabled;
}