"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LabsStrings = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/presentation_util/public/i18n/labs.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const LabsStrings = exports.LabsStrings = {
  Components: {
    Switch: {
      getKibanaSwitchText: () => ({
        name: _i18n.i18n.translate('presentationUtil.labs.components.kibanaSwitchName', {
          defaultMessage: 'Kibana'
        }),
        help: _i18n.i18n.translate('presentationUtil.labs.components.kibanaSwitchHelp', {
          defaultMessage: 'Enables this lab for all Kibana users.'
        })
      }),
      getBrowserSwitchText: () => ({
        name: _i18n.i18n.translate('presentationUtil.labs.components.browserSwitchName', {
          defaultMessage: 'Browser'
        }),
        help: _i18n.i18n.translate('presentationUtil.labs.components.browserSwitchHelp', {
          defaultMessage: 'Enables the lab for this browser and persists after it closes.'
        })
      }),
      getSessionSwitchText: () => ({
        name: _i18n.i18n.translate('presentationUtil.labs.components.sessionSwitchName', {
          defaultMessage: 'Session'
        }),
        help: _i18n.i18n.translate('presentationUtil.labs.components.sessionSwitchHelp', {
          defaultMessage: 'Enables the lab for this browser session, so it resets when it closes.'
        })
      })
    },
    List: {
      getNoProjectsMessage: () => _i18n.i18n.translate('presentationUtil.labs.components.noProjectsMessage', {
        defaultMessage: 'No labs currently available.'
      }),
      getNoProjectsInSolutionMessage: solutionName => _i18n.i18n.translate('presentationUtil.labs.components.noProjectsinSolutionMessage', {
        defaultMessage: 'No labs currently in {solutionName}.',
        values: {
          solutionName
        }
      })
    },
    ListItem: {
      getOverrideLegend: () => _i18n.i18n.translate('presentationUtil.labs.components.overrideFlagsLabel', {
        defaultMessage: 'Overrides'
      }),
      getOverriddenIconTipLabel: () => _i18n.i18n.translate('presentationUtil.labs.components.overridenIconTipLabel', {
        defaultMessage: 'Default overridden'
      }),
      getEnabledStatusMessage: () => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "presentationUtil.labs.components.enabledStatusMessage",
        defaultMessage: "Default: {status}",
        values: {
          status: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 70,
              columnNumber: 21
            }
          }, "Enabled")
        },
        description: "Displays the enabled status of a lab project",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 66,
          columnNumber: 9
        }
      }),
      getDisabledStatusMessage: () => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "presentationUtil.labs.components.disabledStatusMessage",
        defaultMessage: "Default: {status}",
        values: {
          status: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 80,
              columnNumber: 21
            }
          }, "Disabled")
        },
        description: "Displays the disabled status of a lab project",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 76,
          columnNumber: 9
        }
      })
    },
    Flyout: {
      getTitleLabel: () => _i18n.i18n.translate('presentationUtil.labs.components.titleLabel', {
        defaultMessage: 'Labs'
      }),
      getDescriptionMessage: () => _i18n.i18n.translate('presentationUtil.labs.components.descriptionMessage', {
        defaultMessage: 'Try out features that are in progress or in technical preview.'
      }),
      getResetToDefaultLabel: () => _i18n.i18n.translate('presentationUtil.labs.components.resetToDefaultLabel', {
        defaultMessage: 'Reset to defaults'
      }),
      getLabFlagsLabel: () => _i18n.i18n.translate('presentationUtil.labs.components.labFlagsLabel', {
        defaultMessage: 'Lab flags'
      }),
      getRefreshLabel: () => _i18n.i18n.translate('presentationUtil.labs.components.calloutHelp', {
        defaultMessage: 'Refresh to apply changes'
      }),
      getCloseButtonLabel: () => _i18n.i18n.translate('presentationUtil.labs.components.closeButtonLabel', {
        defaultMessage: 'Close'
      })
    }
  }
};