"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAppContext = exports.AppContextProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
var _initial_payload = require("./initial_payload");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/painless_lab/public/application/context/context.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AppContext = /*#__PURE__*/(0, _react.createContext)(undefined);
const validatePayload = payload => {
  const {
    index
  } = payload;

  // For now just validate that the user has entered an index.
  const indexExists = Boolean(index || index.trim());
  return {
    isValid: indexExists,
    fields: {
      index: indexExists
    }
  };
};
const AppContextProvider = ({
  children,
  value: {
    http,
    links,
    chrome
  }
}) => {
  const PAINLESS_LAB_KEY = 'painlessLabState';
  const [store, setStore] = (0, _react.useState)(() => {
    // Using a callback here ensures these values are only calculated on the first render.
    const defaultPayload = {
      ..._initial_payload.initialPayload,
      ...JSON.parse(localStorage.getItem(PAINLESS_LAB_KEY) || '{}')
    };
    return {
      payload: defaultPayload,
      validation: validatePayload(defaultPayload)
    };
  });
  const updatePayload = changes => {
    const nextPayload = {
      ...store.payload,
      ...changes
    };
    // Persist state locally so we can load it up when the user reopens the app.
    localStorage.setItem(PAINLESS_LAB_KEY, JSON.stringify(nextPayload));
    setStore({
      payload: nextPayload,
      validation: validatePayload(nextPayload)
    });
  };
  return /*#__PURE__*/_react.default.createElement(AppContext.Provider, {
    value: {
      updatePayload,
      store,
      services: {
        http,
        chrome
      },
      links
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 5
    }
  }, children);
};
exports.AppContextProvider = AppContextProvider;
const useAppContext = () => {
  const ctx = (0, _react.useContext)(AppContext);
  if (!ctx) {
    throw new Error('AppContext can only be used inside of AppContextProvider!');
  }
  return ctx;
};
exports.useAppContext = useAppContext;