"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ResultTabs = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _results_table = require("../../../results/results_table");
var _action_results_summary = require("../../../action_results/action_results_summary");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/osquery/public/routes/saved_queries/edit/tabs.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const euiTabbedContentCss = {
  'div.euiTabs': {
    paddingLeft: '8px'
  }
};
const ResultTabsComponent = ({
  actionId,
  agentIds,
  ecsMapping,
  endDate,
  failedAgentsCount,
  startDate,
  liveQueryActionId,
  error
}) => {
  const tabs = (0, _react.useMemo)(() => [{
    id: 'results',
    name: 'Results',
    'data-test-subj': 'osquery-results-tab',
    content: /*#__PURE__*/_react.default.createElement(_results_table.ResultsTable, {
      actionId: actionId,
      agentIds: agentIds,
      ecsMapping: ecsMapping,
      startDate: startDate,
      endDate: endDate,
      liveQueryActionId: liveQueryActionId,
      error: error,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 49,
        columnNumber: 11
      }
    })
  }, {
    id: 'status',
    name: 'Status',
    'data-test-subj': 'osquery-status-tab',
    content: /*#__PURE__*/_react.default.createElement(_action_results_summary.ActionResultsSummary, {
      startDate: startDate,
      actionId: actionId,
      agentIds: agentIds,
      expirationDate: endDate,
      error: error,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 65,
        columnNumber: 11
      }
    }),
    append: failedAgentsCount ? /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
      className: "eui-alignCenter",
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 74,
        columnNumber: 11
      }
    }, failedAgentsCount) : null
  }], [actionId, agentIds, ecsMapping, startDate, endDate, liveQueryActionId, error, failedAgentsCount]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTabbedContent, {
    css: euiTabbedContentCss
    // TODO: extend the EuiTabbedContent component to support EuiTabs props
    // bottomBorder={false}
    ,
    tabs: tabs,
    initialSelectedTab: tabs[0],
    autoFocus: "selected",
    expand: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 5
    }
  });
};
const ResultTabs = exports.ResultTabs = /*#__PURE__*/_react.default.memo(ResultTabsComponent);