"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createGenerateConfigPrompt = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createGenerateConfigPrompt = ({
  nlQuery,
  chartType,
  schema,
  existingConfig,
  additionalInstructions,
  additionalContext
}) => {
  return [['system', `You are a Kibana Lens visualization configuration expert. Generate a valid configuration for a ${chartType} visualization based on the provided schema and ES|QL query.

Schema for ${chartType}:
<schema type="${chartType}">
${JSON.stringify(schema, null, 2)}
</schema>

${existingConfig ? `Existing configuration to modify: 
  <existing_configuration>
  ${existingConfig}
  </existing_configuration>
  ` : ''}
  
${existingConfig ? `Existing configuration to modify: ${existingConfig}` : ''}

${additionalInstructions}

Your task is to generate a ${chartType} visualization configuration based on the following information:

<user_query>
${nlQuery}
</user_query>

Generate the ${chartType} visualization configuration.

IMPORTANT: Return ONLY the JSON configuration wrapped in a markdown code block like this:
\`\`\`json
{
  // your configuration here
}
\`\`\`

${additionalContext}`]];
};
exports.createGenerateConfigPrompt = createGenerateConfigPrompt;