"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.selectTools = void 0;
var _onechatCommon = require("@kbn/onechat-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const selectTools = async ({
  input,
  conversation,
  request,
  toolProvider,
  agentConfiguration,
  attachmentsService
}) => {
  // create tool selection for attachments
  const attachmentTypes = getActiveAttachmentTypes(input, conversation);
  const attachmentToolIds = getToolsForAttachmentTypes(attachmentTypes, attachmentsService);
  const attachmentToolSelection = {
    tool_ids: attachmentToolIds
  };

  // pick tools from provider
  return await pickTools({
    selection: [attachmentToolSelection, ...agentConfiguration.tools],
    toolProvider,
    request
  });
};
exports.selectTools = selectTools;
const getToolsForAttachmentTypes = (attachmentTypes, attachmentsService) => {
  const tools = new Set();
  for (const type of attachmentTypes) {
    const definition = attachmentsService.getTypeDefinition(type);
    if (definition && definition.getTools) {
      const definitionTools = definition.getTools();
      definitionTools.forEach(toolId => tools.add(toolId));
    }
  }
  return [...tools];
};

/**
 * Returns the list of attachment types that are currently used in the conversation.
 */
const getActiveAttachmentTypes = (input, conversation) => {
  var _input$attachments, _conversation$rounds$;
  const attachments = [...((_input$attachments = input.attachments) !== null && _input$attachments !== void 0 ? _input$attachments : []), ...((_conversation$rounds$ = conversation === null || conversation === void 0 ? void 0 : conversation.rounds.flatMap(round => {
    var _round$input$attachme;
    return (_round$input$attachme = round.input.attachments) !== null && _round$input$attachme !== void 0 ? _round$input$attachme : [];
  })) !== null && _conversation$rounds$ !== void 0 ? _conversation$rounds$ : [])];
  return [...new Set(attachments.map(att => att.type))];
};
const pickTools = async ({
  toolProvider,
  selection,
  request
}) => {
  const tools = await toolProvider.list({
    request
  });
  return (0, _onechatCommon.filterToolsBySelection)(tools, selection);
};