"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createEmbeddableConversation = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _embeddable_conversation = require("./embeddable_conversation");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/embeddable/create_embeddable_conversation.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/**
 * Factory function that creates an embeddable Conversation component
 * with services injected via closure.
 *
 * @param services - Internal onechat services
 * @param coreStart - Kibana core start services
 * @returns A configured Conversation component ready for external consumption
 */
const createEmbeddableConversation = ({
  services,
  coreStart
}) => {
  return props => /*#__PURE__*/_react.default.createElement(_embeddable_conversation.EmbeddableConversationInternal, (0, _extends2.default)({}, props, {
    coreStart: coreStart,
    services: services,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 5
    }
  }));
};
exports.createEmbeddableConversation = createEmbeddableConversation;