"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Configuration = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactHookForm = require("react-hook-form");
var _doc_links = require("../../../../../../common/doc_links");
var _tool_form_section = require("../components/tool_form_section");
var _i18n = require("../i18n");
var _tools_form_registry = require("../registry/tools_form_registry");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/tools/form/sections/configuration.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const Configuration = () => {
  const {
    control
  } = (0, _reactHookForm.useFormContext)();
  const type = (0, _reactHookForm.useWatch)({
    control,
    name: 'type'
  });
  const toolConfig = (0, _tools_form_registry.getToolTypeConfig)(type);
  const ConfigurationComponent = (0, _react.useMemo)(() => {
    return toolConfig.getConfigurationComponent();
  }, [toolConfig]);
  return /*#__PURE__*/_react.default.createElement(_tool_form_section.ToolFormSection, {
    title: _i18n.i18nMessages.configuration.documentation.title,
    icon: "code",
    description: _i18n.i18nMessages.configuration.documentation.description,
    documentation: {
      title: _i18n.i18nMessages.configuration.documentation.documentationLink,
      href: _doc_links.docLinks.tools
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 25,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(ConfigurationComponent, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 7
    }
  }));
};
exports.Configuration = Configuration;