"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConversationTitle = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _use_conversation = require("../../../hooks/use_conversation");
var _delete_conversation_modal = require("./delete_conversation_modal");
var _rename_conversation_modal = require("./rename_conversation_modal");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/conversations/conversation_header/conversation_title.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const labels = {
  ariaLabel: _i18n.i18n.translate('xpack.onechat.conversationTitle.ariaLabel', {
    defaultMessage: 'Conversation title'
  }),
  rename: _i18n.i18n.translate('xpack.onechat.conversationTitle.rename', {
    defaultMessage: 'Rename'
  }),
  delete: _i18n.i18n.translate('xpack.onechat.conversationTitle.delete', {
    defaultMessage: 'Delete'
  })
};
const ConversationTitle = ({
  ariaLabelledBy
}) => {
  const {
    title,
    isLoading
  } = (0, _use_conversation.useConversationTitle)();
  const hasActiveConversation = (0, _use_conversation.useHasActiveConversation)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [isContextMenuOpen, setIsContextMenuOpen] = (0, _react.useState)(false);
  const [isDeleteModalOpen, setIsDeleteModalOpen] = (0, _react.useState)(false);
  const [isRenameModalOpen, setIsRenameModalOpen] = (0, _react.useState)(false);
  const shouldShowButton = hasActiveConversation && !isLoading && title;
  const menuItems = [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "rename",
    icon: "pencil",
    size: "s",
    "data-test-subj": "agentBuilderConversationRenameButton",
    onClick: () => {
      setIsContextMenuOpen(false);
      setIsRenameModalOpen(true);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 5
    }
  }, labels.rename), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "delete",
    icon: "trash",
    size: "s",
    css: (0, _react2.css)`
        color: ${euiTheme.colors.textDanger};
      `,
    "data-test-subj": "agentBuilderConversationDeleteButton",
    onClick: () => {
      setIsContextMenuOpen(false);
      setIsDeleteModalOpen(true);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 5
    }
  }, labels.delete)];
  if (shouldShowButton) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        onClick: () => setIsContextMenuOpen(!isContextMenuOpen),
        "aria-label": labels.ariaLabel,
        iconType: "arrowDown",
        iconSide: "right",
        color: "text",
        "data-test-subj": "agentBuilderConversationTitle",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 83,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement("h1", {
        id: ariaLabelledBy,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 91,
          columnNumber: 15
        }
      }, title)),
      isOpen: isContextMenuOpen,
      closePopover: () => setIsContextMenuOpen(false),
      panelPaddingSize: "s",
      anchorPosition: "downCenter",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 81,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
      size: "s",
      items: menuItems,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 99,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement(_delete_conversation_modal.DeleteConversationModal, {
      isOpen: isDeleteModalOpen,
      onClose: () => setIsDeleteModalOpen(false),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 101,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_rename_conversation_modal.RenameConversationModal, {
      isOpen: isRenameModalOpen,
      onClose: () => setIsRenameModalOpen(false),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 105,
        columnNumber: 9
      }
    }));
  }
  return null;
};
exports.ConversationTitle = ConversationTitle;