"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSampleDocs = void 0;
var _lodash = require("lodash");
var _std = require("@kbn/std");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Return sample documents from the specified index, alias or datastream
 */
const getSampleDocs = async ({
  index,
  size = 100,
  _source = false,
  fields = [{
    field: '*',
    include_unmapped: true
  }],
  esClient
}) => {
  const {
    hits
  } = await esClient.search({
    index,
    size,
    query: {
      bool: {
        should: [{
          function_score: {
            functions: [{
              random_score: {}
            }]
          }
        }]
      }
    },
    fields,
    _source,
    sort: {
      _score: {
        order: 'desc'
      }
    }
  });
  const samples = hits.hits.map(mapSearchHit);
  return {
    samples
  };
};
exports.getSampleDocs = getSampleDocs;
const mapSearchHit = hit => {
  var _hit$_source, _hit$fields;
  const source = (0, _std.getFlattenedObject)((_hit$_source = hit._source) !== null && _hit$_source !== void 0 ? _hit$_source : {});
  const fields = (_hit$fields = hit.fields) !== null && _hit$fields !== void 0 ? _hit$fields : {};
  const values = Object.entries({
    ...fields,
    ...source
  }).reduce((map, [key, value]) => {
    map[key] = (0, _lodash.uniq)((0, _lodash.castArray)(value).filter(isPrimitive));
    return map;
  }, {});
  return {
    id: hit._id,
    index: hit._index,
    values
  };
};
const isPrimitive = value => {
  return typeof value === 'string' || typeof value === 'number' || typeof value === 'boolean';
};