"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "TRANSACTION_DETAILS_BY_TRACE_ID_LOCATOR", {
  enumerable: true,
  get: function () {
    return _deeplinksObservability.TRANSACTION_DETAILS_BY_TRACE_ID_LOCATOR;
  }
});
exports.TransactionDetailsByTraceIdLocatorDefinition = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _queryString = _interopRequireDefault(require("query-string"));
var _deeplinksObservability = require("@kbn/deeplinks-observability");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class TransactionDetailsByTraceIdLocatorDefinition {
  constructor() {
    (0, _defineProperty2.default)(this, "id", _deeplinksObservability.TRANSACTION_DETAILS_BY_TRACE_ID_LOCATOR);
    (0, _defineProperty2.default)(this, "getLocation", async ({
      rangeFrom,
      rangeTo,
      waterfallItemId,
      traceId
    }) => {
      const params = {
        rangeFrom,
        rangeTo,
        waterfallItemId
      };
      return {
        app: 'apm',
        path: `/link-to/trace/${encodeURIComponent(traceId)}?${_queryString.default.stringify(params)}`,
        state: {}
      };
    });
  }
}
exports.TransactionDetailsByTraceIdLocatorDefinition = TransactionDetailsByTraceIdLocatorDefinition;