"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Tags = Tags;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability/public/components/tags.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function Tags({
  tags,
  color,
  size = 3,
  oneLine = false
}) {
  const [isMoreTagsOpen, setIsMoreTagsOpen] = (0, _react.useState)(false);
  const onMoreTagsClick = e => {
    e.stopPropagation();
    setIsMoreTagsOpen(isPopoverOpen => !isPopoverOpen);
  };
  const closePopover = () => setIsMoreTagsOpen(false);
  const moreTags = tags.length > size && /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    key: "more",
    onClick: onMoreTagsClick,
    onClickAriaLabel: _i18n.i18n.translate('xpack.observability.component.tags.moreTags.ariaLabel', {
      defaultMessage: 'more tags badge'
    }),
    color: color,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observability.component.tags.moreTags",
    defaultMessage: "+{number} more",
    values: {
      number: tags.length - size
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 7
    }
  }));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, tags.slice(0, size).map(tag => /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    key: tag,
    color: color,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 9
    }
  }, tag)), oneLine ? ' ' : /*#__PURE__*/_react.default.createElement("br", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 24
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: moreTags,
    isOpen: isMoreTagsOpen,
    closePopover: closePopover,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 7
    }
  }, tags.slice(size).map(tag => /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    key: tag,
    color: color,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 11
    }
  }, tag))));
}