"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.formatCase = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const formatCase = theCase => {
  var _theCase$created_by$u, _theCase$created_by$f;
  return {
    title: theCase.title,
    description: theCase.description,
    createdAt: theCase.created_at,
    createdBy: {
      username: (_theCase$created_by$u = theCase.created_by.username) !== null && _theCase$created_by$u !== void 0 ? _theCase$created_by$u : undefined,
      fullName: (_theCase$created_by$f = theCase.created_by.full_name) !== null && _theCase$created_by$f !== void 0 ? _theCase$created_by$f : undefined
    },
    status: theCase.status,
    totalComments: theCase.totalComment
  };
};
exports.formatCase = formatCase;