"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderDiscoverRedirect = exports.DiscoverRedirect = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _rison = require("@kbn/rison");
var _logs_explorer_url_schema = require("./logs_explorer_url_schema");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability_logs_explorer/public/redirect_to_discover.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const DEFAULT_ALL_SELECTION = {
  selectionType: 'all'
};
const renderDiscoverRedirect = (core, discover, appParams) => {
  _reactDom.default.render(/*#__PURE__*/_react.default.createElement(_sharedUxRouter.Router, {
    history: appParams.history,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(DiscoverRedirect, {
    core: core,
    discover: discover,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 7
    }
  })), appParams.element);
  return () => {
    _reactDom.default.unmountComponentAtNode(appParams.element);
  };
};
exports.renderDiscoverRedirect = renderDiscoverRedirect;
const DiscoverRedirect = ({
  core,
  discover
}) => {
  const location = (0, _reactRouterDom.useLocation)();
  const searchParams = new URLSearchParams(location.search);
  const pageStateEncoded = searchParams.get('pageState') || '';
  const rawPageState = (0, _rison.safeDecode)(pageStateEncoded) || {};
  const parsedState = (0, _logs_explorer_url_schema.normalizeUrlState)(rawPageState);
  if (parsedState) {
    var _parsedState$chart$br, _parsedState$chart, _parsedState$grid, _parsedState$grid$row, _parsedState$grid2, _parsedState$grid2$ro, _discover$locator;
    const dataViewSpec = parsedState.dataSourceSelection ? (0, _logs_explorer_url_schema.hydrateDataSourceSelection)(parsedState.dataSourceSelection) : (0, _logs_explorer_url_schema.hydrateDataSourceSelection)(DEFAULT_ALL_SELECTION);
    const discoverParams = {
      timeRange: parsedState.time,
      refreshInterval: parsedState.refreshInterval,
      filters: (0, _logs_explorer_url_schema.getDiscoverFiltersFromState)(dataViewSpec.id, parsedState.filters),
      query: parsedState.query,
      breakdownField: (_parsedState$chart$br = (_parsedState$chart = parsedState.chart) === null || _parsedState$chart === void 0 ? void 0 : _parsedState$chart.breakdownField) !== null && _parsedState$chart$br !== void 0 ? _parsedState$chart$br : undefined,
      columns: (0, _logs_explorer_url_schema.getDiscoverColumnsWithFallbackFieldsFromDisplayOptions)(parsedState),
      grid: {
        rowHeight: (_parsedState$grid = parsedState.grid) === null || _parsedState$grid === void 0 ? void 0 : (_parsedState$grid$row = _parsedState$grid.rows) === null || _parsedState$grid$row === void 0 ? void 0 : _parsedState$grid$row.rowHeight,
        rowsPerPage: (_parsedState$grid2 = parsedState.grid) === null || _parsedState$grid2 === void 0 ? void 0 : (_parsedState$grid2$ro = _parsedState$grid2.rows) === null || _parsedState$grid2$ro === void 0 ? void 0 : _parsedState$grid2$ro.rowsPerPage
      }
    };
    if (parsedState.dataSourceSelection) {
      if (parsedState.dataSourceSelection.selectionType === 'single' || parsedState.dataSourceSelection.selectionType === 'unresolved') {
        discoverParams.dataViewSpec = dataViewSpec;
      } else {
        discoverParams.dataViewId = dataViewSpec.id;
      }
    } else {
      discoverParams.dataViewId = dataViewSpec.id;
    }
    (_discover$locator = discover.locator) === null || _discover$locator === void 0 ? void 0 : _discover$locator.navigate(discoverParams);
  } else {
    var _discover$locator2;
    (_discover$locator2 = discover.locator) === null || _discover$locator2 === void 0 ? void 0 : _discover$locator2.navigate({});
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
};
exports.DiscoverRedirect = DiscoverRedirect;